/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.fabric.executor.Location;
import org.neo4j.gqlstatus.ErrorClassification;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlClassification;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class FabricException
extends GqlRuntimeException
implements Status.HasStatus,
HasQuery {
    private final Status statusCode;
    private Long queryId;
    private static final String ROUTING_ENABLED_SETTING = GraphDatabaseSettings.routing_enabled.name();

    @Deprecated
    public FabricException(Status statusCode, Throwable cause) {
        super(ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    private FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, Throwable cause) {
        super(gqlStatusObject, ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public FabricException(Status statusCode, String message, Object ... parameters) {
        super(String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    private FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Object ... parameters) {
        super(gqlStatusObject, String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public FabricException(Status statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    protected FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public FabricException(Status statusCode, String message, Throwable cause, Long queryId) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = queryId;
    }

    private FabricException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Throwable cause, Long queryId) {
        super(gqlStatusObject, message, cause);
        this.statusCode = statusCode;
        this.queryId = queryId;
    }

    public static FabricException noLeaderAddress(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N00).withClassification((GqlClassification)ErrorClassification.TRANSIENT_ERROR).withParam(GqlParams.StringParam.db, dbName).build();
        return new FabricException(gql, (Status)Status.Cluster.NotALeader, "Unable to route to database '%s'. Unable to get bolt address of leader.", dbName);
    }

    public static FabricException sessionDbNotLeader(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N01).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.db, dbName).withParam(GqlParams.StringParam.cfgSetting, ROUTING_ENABLED_SETTING).build();
        return new FabricException(gql, (Status)Status.Cluster.NotALeader, String.format("No longer possible to write to database '%s' on this instance and unable to route write operation to leader. Server-side routing is disabled.\nEither connect to the database directly using the driver (or interactively with the :use command),\nor enable server-side routing by setting `%s=true`", dbName, ROUTING_ENABLED_SETTING), dbName);
    }

    public static FabricException routingDisabled(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N02).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).withParam(GqlParams.StringParam.db, dbName).withParam(GqlParams.StringParam.cfgSetting, ROUTING_ENABLED_SETTING).build();
        return new FabricException(gql, (Status)Status.Cluster.Routing, String.format("Unable to route to database '%s'. Server-side routing is disabled.\nEither connect to the database directly using the driver (or interactively with the :use command),\nor enable server-side routing by setting `%s=true`", dbName, ROUTING_ENABLED_SETTING), dbName);
    }

    public static FabricException failedToParseBookmark(Exception exception) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N12).withClassification((GqlClassification)ErrorClassification.CLIENT_ERROR).build();
        return new FabricException(gql, (Status)Status.Transaction.InvalidBookmark, "Parsing of supplied bookmarks failed with message: " + exception.getMessage(), exception);
    }

    public static FabricException writeDuringLeaderSwitch(Location attempt, Location current) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N34).withClassification((GqlClassification)ErrorClassification.TRANSIENT_ERROR).build();
        return new FabricException(gql, (Status)Status.Transaction.LeaderSwitch, "Could not write to a database due to a cluster leader switch that occurred during the transaction. Previous leader: %s, Current leader: %s.", current, attempt);
    }

    public static FabricException databaseLocationChanged(String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N35).withClassification((GqlClassification)ErrorClassification.TRANSIENT_ERROR).withParam(GqlParams.StringParam.db, dbName).build();
        return new FabricException(gql, (Status)Status.Transaction.Outdated, "The locations associated with the graph name %s have changed whilst the transaction was running.", dbName);
    }

    public static FabricException executeQueryInClosedTransaction() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N07).withClassification((GqlClassification)ErrorClassification.DATABASE_ERROR).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N05).withClassification((GqlClassification)ErrorClassification.DATABASE_ERROR).build()).build();
        return new FabricException((Status)Status.Statement.ExecutionFailed, "Trying to execute query in a closed transaction", new Object[0]);
    }

    public Status status() {
        return this.statusCode;
    }

    public Long query() {
        return this.queryId;
    }

    public void setQuery(Long queryId) {
        this.queryId = queryId;
    }
}

