/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.fabric.stream.Record;
import org.neo4j.values.AnyValue;

public class Records {
    public static Record empty() {
        return Records.of(List.of());
    }

    public static Record of(List<AnyValue> values) {
        return new ListRecord(values);
    }

    public static Record of(AnyValue[] values) {
        return new ListRecord(List.of(values));
    }

    public static Record join(Record lhs, Record rhs) {
        return new JoinedRecord(lhs, rhs);
    }

    public static Record lazy(int size, Supplier<Record> recordSupplier) {
        return new LazyConvertingRecord(size, recordSupplier);
    }

    public static Map<String, AnyValue> asMap(Record record, List<String> columns) {
        HashMap<String, AnyValue> map = new HashMap<String, AnyValue>();
        for (int i = 0; i < columns.size(); ++i) {
            map.put(columns.get(i), record.getValue(i));
        }
        return map;
    }

    public static Iterator<AnyValue> iterator(final Record record) {
        return new Iterator<AnyValue>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < record.size();
            }

            @Override
            public AnyValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return record.getValue(this.i++);
            }
        };
    }

    public static Iterable<AnyValue> iterable(Record record) {
        return () -> Records.iterator(record);
    }

    public static Stream<AnyValue> stream(Record record) {
        return StreamSupport.stream(Records.iterable(record).spliterator(), false);
    }

    public static String show(Record record) {
        return Records.stream(record).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    private static class ListRecord
    extends Record {
        private final List<AnyValue> values;

        private ListRecord(List<AnyValue> values) {
            this.values = values;
        }

        @Override
        public AnyValue getValue(int offset) {
            return this.values.get(offset);
        }

        @Override
        public int size() {
            return this.values.size();
        }
    }

    private static class JoinedRecord
    extends Record {
        private final Record lhs;
        private final Record rhs;

        private JoinedRecord(Record lhs, Record rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public AnyValue getValue(int offset) {
            if (offset < this.lhs.size()) {
                return this.lhs.getValue(offset);
            }
            return this.rhs.getValue(offset - this.lhs.size());
        }

        @Override
        public int size() {
            return this.lhs.size() + this.rhs.size();
        }
    }

    private static class LazyConvertingRecord
    extends Record {
        private final int size;
        private final Supplier<Record> recordSupplier;
        private Record convertedRecord;

        LazyConvertingRecord(int size, Supplier<Record> recordSupplier) {
            this.size = size;
            this.recordSupplier = recordSupplier;
        }

        @Override
        public AnyValue getValue(int offset) {
            this.maybeConvert();
            return this.convertedRecord.getValue(offset);
        }

        @Override
        public int size() {
            return this.size;
        }

        private void maybeConvert() {
            if (this.convertedRecord == null) {
                this.convertedRecord = this.recordSupplier.get();
            }
        }
    }
}

