/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.neo4j.fabric.stream.QuerySubject;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class StatementResults {
    private StatementResults() {
    }

    public static StatementResult map(StatementResult statementResult, UnaryOperator<Flux<Record>> func) {
        return new BasicStatementResult(statementResult.columns(), (Flux<Record>)((Flux)func.apply(statementResult.records())), statementResult.summary(), statementResult.executionType());
    }

    public static StatementResult initial() {
        return new BasicStatementResult(Collections.emptyList(), (Flux<Record>)Flux.just((Object)Records.empty()), (Mono<Summary>)Mono.empty(), (Mono<QueryExecutionType>)Mono.empty());
    }

    public static StatementResult connectVia(SubscribableExecution execution, QuerySubject subject) {
        QueryExecution queryExecution = execution.subscribe(subject);
        subject.setQueryExecution(queryExecution);
        return StatementResults.create(Arrays.asList(queryExecution.fieldNames()), (Flux<Record>)Flux.from((Publisher)subject), subject.getSummary(), (Mono<QueryExecutionType>)Mono.just((Object)queryExecution.executionType()));
    }

    public static StatementResult create(List<String> columns, Flux<Record> records, Mono<Summary> summary, Mono<QueryExecutionType> executionType) {
        return new BasicStatementResult(columns, records, summary, executionType);
    }

    public static <E extends Throwable> StatementResult withErrorMapping(StatementResult statementResult, Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Flux records = statementResult.records().onErrorMap(type, mapper);
        Mono summary = statementResult.summary().onErrorMap(type, mapper);
        Mono executionType = statementResult.executionType().onErrorMap(type, mapper);
        return StatementResults.create(statementResult.columns(), (Flux<Record>)records, (Mono<Summary>)summary, (Mono<QueryExecutionType>)executionType);
    }

    public static StatementResult error(Throwable err) {
        return new BasicStatementResult(Collections.emptyList(), (Flux<Record>)Flux.error((Throwable)err), (Mono<Summary>)Mono.error((Throwable)err), (Mono<QueryExecutionType>)Mono.error((Throwable)err));
    }

    public static StatementResult trace(StatementResult input) {
        return new BasicStatementResult(input.columns(), (Flux<Record>)input.records().doOnEach(signal -> {
            if (signal.hasValue()) {
                System.out.println(String.join((CharSequence)", ", signal.getType().toString(), Records.show((Record)signal.get())));
            } else if (signal.hasError()) {
                System.out.println(String.join((CharSequence)", ", signal.getType().toString(), signal.getThrowable().toString()));
            } else {
                System.out.println(String.join((CharSequence)", ", signal.getType().toString()));
            }
        }), input.summary(), input.executionType());
    }

    private static class BasicStatementResult
    implements StatementResult {
        private final List<String> columns;
        private final Flux<Record> records;
        private final Mono<Summary> summary;
        private final Mono<QueryExecutionType> executionType;

        BasicStatementResult(List<String> columns, Flux<Record> records, Mono<Summary> summary, Mono<QueryExecutionType> executionType) {
            this.columns = columns;
            this.records = records;
            this.summary = summary;
            this.executionType = executionType;
        }

        @Override
        public List<String> columns() {
            return this.columns;
        }

        @Override
        public Flux<Record> records() {
            return this.records;
        }

        @Override
        public Mono<Summary> summary() {
            return this.summary;
        }

        @Override
        public Mono<QueryExecutionType> executionType() {
            return this.executionType;
        }
    }

    @FunctionalInterface
    public static interface SubscribableExecution {
        public QueryExecution subscribe(QuerySubscriber var1);
    }
}

