/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.SingleDbTransaction;
import org.neo4j.fabric.planning.StatementType;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.transaction.CompositeTransaction;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FabricTransactionImpl
implements FabricTransaction,
CompositeTransaction,
FabricTransaction.FabricExecutionContext {
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private final Set<ReadingTransaction> readingTransactions = ConcurrentHashMap.newKeySet();
    private final ReadWriteLock transactionLock = new ReentrantReadWriteLock();
    private final Lock nonExclusiveLock = this.transactionLock.readLock();
    private final Lock exclusiveLock = this.transactionLock.writeLock();
    private final FabricTransactionInfo transactionInfo;
    private final TransactionBookmarkManager bookmarkManager;
    private final Catalog catalogSnapshot;
    private final Map<Catalog.Graph, Location> locationCache;
    private final ErrorReporter errorReporter;
    private final TransactionManager transactionManager;
    private final FabricConfig fabricConfig;
    private final long id;
    private final FabricRemoteExecutor.RemoteTransactionContext remoteTransactionContext;
    private final FabricLocalExecutor.LocalTransactionContext localTransactionContext;
    private final AtomicReference<StatementType> statementType = new AtomicReference();
    private State state = State.OPEN;
    private Status terminationStatus;
    private FabricStatementLifecycles.StatementLifecycle lastSubmittedStatement;
    private SingleDbTransaction writingTransaction;

    FabricTransactionImpl(FabricTransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager, FabricRemoteExecutor remoteExecutor, FabricLocalExecutor localExecutor, ErrorReporter errorReporter, TransactionManager transactionManager, FabricConfig fabricConfig, Catalog catalogSnapshot) {
        this.transactionInfo = transactionInfo;
        this.errorReporter = errorReporter;
        this.transactionManager = transactionManager;
        this.fabricConfig = fabricConfig;
        this.bookmarkManager = bookmarkManager;
        this.catalogSnapshot = catalogSnapshot;
        this.locationCache = new HashMap<Catalog.Graph, Location>();
        this.id = ID_GENERATOR.incrementAndGet();
        try {
            this.remoteTransactionContext = remoteExecutor.startTransactionContext(this, transactionInfo, bookmarkManager);
            this.localTransactionContext = localExecutor.startTransactionContext(this, transactionInfo, bookmarkManager);
        }
        catch (RuntimeException e) {
            throw Exceptions.transform((Status)Status.Transaction.TransactionStartFailed, e);
        }
    }

    @Override
    public Catalog getCatalogSnapshot() {
        return this.catalogSnapshot;
    }

    @Override
    public FabricTransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    @Override
    public FabricRemoteExecutor.RemoteTransactionContext getRemote() {
        return this.remoteTransactionContext;
    }

    @Override
    public FabricLocalExecutor.LocalTransactionContext getLocal() {
        return this.localTransactionContext;
    }

    @Override
    public void validateStatementType(StatementType type) {
        StatementType oldType;
        boolean wasNull = this.statementType.compareAndSet(null, type);
        if (!wasNull && (oldType = this.statementType.get()) != type) {
            boolean allowedCombination;
            boolean queryAfterQuery = type.isQuery() && oldType.isQuery();
            boolean readQueryAfterSchema = type.isReadQuery() && oldType.isSchemaCommand();
            boolean schemaAfterReadQuery = type.isSchemaCommand() && oldType.isReadQuery();
            boolean bl = allowedCombination = queryAfterQuery || readQueryAfterSchema || schemaAfterReadQuery;
            if (allowedCombination) {
                boolean upgrade;
                boolean writeQueryAfterReadQuery = queryAfterQuery && !type.isReadQuery() && oldType.isReadQuery();
                boolean bl2 = upgrade = writeQueryAfterReadQuery || schemaAfterReadQuery;
                if (upgrade) {
                    this.statementType.set(type);
                }
            } else {
                throw new FabricException((Status)Status.Transaction.ForbiddenDueToTransactionType, "Tried to execute %s after executing %s", type, oldType);
            }
        }
    }

    public boolean isSchemaTransaction() {
        StatementType type = this.statementType.get();
        return type != null && type.isSchemaCommand();
    }

    @Override
    public DatabaseReference getSessionDatabaseReference() {
        return this.transactionInfo.getSessionDatabaseReference();
    }

    @Override
    public Location getOrComputeLocation(Catalog.Graph graph, Supplier<Location> locationOf) {
        return this.locationCache.computeIfAbsent(graph, g -> (Location)locationOf.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.exclusiveLock.lock();
        try {
            if (this.state == State.TERMINATED) {
                FabricTransactionImpl.doOnChildren(this.readingTransactions, this.writingTransaction, SingleDbTransaction::rollback);
                throw new TransactionTerminatedException(this.terminationStatus);
            }
            if (this.state == State.CLOSED) {
                throw new FabricException((Status)Status.Transaction.TransactionCommitFailed, "Trying to commit closed transaction", new Object[0]);
            }
            this.state = State.CLOSED;
            ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
            try {
                FabricTransactionImpl.doOnChildren(this.readingTransactions, null, SingleDbTransaction::commit).forEach(error -> allFailures.add(new ErrorRecord("Failed to commit a child read transaction", (Throwable)error)));
                if (!allFailures.isEmpty()) {
                    FabricTransactionImpl.doOnChildren(List.of(), this.writingTransaction, SingleDbTransaction::rollback).forEach(error -> allFailures.add(new ErrorRecord("Failed to rollback a child write transaction", (Throwable)error)));
                } else {
                    FabricTransactionImpl.doOnChildren(List.of(), this.writingTransaction, SingleDbTransaction::commit).forEach(error -> allFailures.add(new ErrorRecord("Failed to commit a child write transaction", (Throwable)error)));
                }
            }
            catch (Exception e) {
                allFailures.add(new ErrorRecord("Failed to commit composite transaction", this.commitFailedError()));
            }
            finally {
                this.remoteTransactionContext.close();
                this.localTransactionContext.close();
                this.transactionManager.removeTransaction(this);
            }
            this.throwIfNonEmpty(allFailures, this::commitFailedError);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public void rollback() {
        this.exclusiveLock.lock();
        try {
            if (this.remoteTransactionContext == null && this.localTransactionContext == null) {
                return;
            }
            if (this.state == State.TERMINATED) {
                FabricTransactionImpl.doOnChildren(this.readingTransactions, this.writingTransaction, SingleDbTransaction::rollback);
                return;
            }
            if (this.state == State.CLOSED) {
                return;
            }
            this.state = State.CLOSED;
            this.doRollback(SingleDbTransaction::rollback);
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback(Function<SingleDbTransaction, Mono<Void>> operation) {
        ArrayList<ErrorRecord> allFailures = new ArrayList<ErrorRecord>();
        try {
            FabricTransactionImpl.doOnChildren(this.readingTransactions, this.writingTransaction, operation).forEach(error -> allFailures.add(new ErrorRecord("Failed to rollback a child transaction", (Throwable)error)));
        }
        catch (Exception e) {
            allFailures.add(new ErrorRecord("Failed to rollback composite transaction", this.rollbackFailedError()));
        }
        finally {
            this.remoteTransactionContext.close();
            this.localTransactionContext.close();
            this.transactionManager.removeTransaction(this);
        }
        this.throwIfNonEmpty(allFailures, this::rollbackFailedError);
    }

    private static List<Throwable> doOnChildren(Iterable<ReadingTransaction> readingTransactions, SingleDbTransaction writingTransaction, Function<SingleDbTransaction, Mono<Void>> operation) {
        List failures = (List)Flux.fromIterable(readingTransactions).map(txWrapper -> txWrapper.singleDbTransaction).concatWith((Publisher)Mono.justOrEmpty((Object)writingTransaction)).flatMap(tx -> FabricTransactionImpl.catchErrors((Mono<Void>)((Mono)operation.apply((SingleDbTransaction)tx)))).collectList().block();
        return failures == null ? List.of() : failures;
    }

    private static Mono<Throwable> catchErrors(Mono<Void> action) {
        return action.flatMap(v -> Mono.empty()).onErrorResume(Mono::just);
    }

    private void throwIfNonEmpty(List<ErrorRecord> failures, Supplier<FabricException> genericException) {
        if (!failures.isEmpty()) {
            FabricException exception = genericException.get();
            if (failures.size() == 1) {
                throw Exceptions.transform(exception.status(), failures.get((int)0).error);
            }
            failures.forEach(failure -> exception.addSuppressed(failure.error));
            failures.forEach(failure -> this.errorReporter.report(failure.message, failure.error, exception.status()));
            throw exception;
        }
    }

    @Override
    public StatementResult execute(Function<FabricTransaction.FabricExecutionContext, StatementResult> runLogic) {
        this.checkTransactionOpenForStatementExecution();
        try {
            return runLogic.apply(this);
        }
        catch (RuntimeException e) {
            this.rollback();
            throw Exceptions.transform((Status)Status.Statement.ExecutionFailed, e);
        }
    }

    private void checkTransactionOpenForStatementExecution() {
        if (this.state == State.TERMINATED) {
            throw new TransactionTerminatedException(this.terminationStatus);
        }
        if (this.state == State.CLOSED) {
            throw new FabricException((Status)Status.Statement.ExecutionFailed, "Trying to execute query in a closed transaction", new Object[0]);
        }
    }

    @Override
    public void setLastSubmittedStatement(FabricStatementLifecycles.StatementLifecycle statement) {
        this.lastSubmittedStatement = statement;
    }

    @Override
    public Optional<FabricStatementLifecycles.StatementLifecycle> getLastSubmittedStatement() {
        return Optional.ofNullable(this.lastSubmittedStatement);
    }

    public boolean isLocal() {
        return this.remoteTransactionContext.isEmptyContext();
    }

    @Override
    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    @Override
    public void markForTermination(Status reason) {
        this.exclusiveLock.lock();
        try {
            if (this.state != State.OPEN) {
                return;
            }
            this.terminationStatus = reason;
            this.state = State.TERMINATED;
            this.doRollback(singleDbTransaction -> singleDbTransaction.terminate(reason));
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public Optional<Status> getReasonIfTerminated() {
        if (this.terminationStatus != null) {
            return Optional.of(this.terminationStatus);
        }
        return Optional.empty();
    }

    @Override
    public TransactionBookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    @Override
    public void setMetaData(Map<String, Object> txMeta) {
        this.transactionInfo.setMetaData(txMeta);
        for (InternalTransaction internalTransaction : this.getInternalTransactions()) {
            internalTransaction.setMetaData(txMeta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TX extends SingleDbTransaction> TX startWritingTransaction(Location location, Supplier<TX> writeTransactionSupplier) throws FabricException {
        this.exclusiveLock.lock();
        try {
            SingleDbTransaction tx;
            this.checkTransactionOpenForStatementExecution();
            if (this.writingTransaction != null) {
                throw this.multipleWriteError(location);
            }
            this.writingTransaction = tx = (SingleDbTransaction)writeTransactionSupplier.get();
            SingleDbTransaction singleDbTransaction = tx;
            return (TX)singleDbTransaction;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public <TX extends SingleDbTransaction> TX startReadingTransaction(Location location, Supplier<TX> readingTransactionSupplier) throws FabricException {
        return this.startReadingTransaction(location, false, readingTransactionSupplier);
    }

    @Override
    public <TX extends SingleDbTransaction> TX startReadingOnlyTransaction(Location location, Supplier<TX> readingTransactionSupplier) throws FabricException {
        return this.startReadingTransaction(location, true, readingTransactionSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TX extends SingleDbTransaction> TX startReadingTransaction(Location location, boolean readOnly, Supplier<TX> readingTransactionSupplier) throws FabricException {
        this.nonExclusiveLock.lock();
        try {
            this.checkTransactionOpenForStatementExecution();
            SingleDbTransaction tx = (SingleDbTransaction)readingTransactionSupplier.get();
            this.readingTransactions.add(new ReadingTransaction(tx, readOnly));
            SingleDbTransaction singleDbTransaction = tx;
            return (TX)singleDbTransaction;
        }
        finally {
            this.nonExclusiveLock.unlock();
        }
    }

    @Override
    public <TX extends SingleDbTransaction> void upgradeToWritingTransaction(TX writingTransaction) throws FabricException {
        if (this.writingTransaction == writingTransaction) {
            return;
        }
        this.exclusiveLock.lock();
        try {
            if (this.writingTransaction == writingTransaction) {
                return;
            }
            if (this.writingTransaction != null) {
                throw this.multipleWriteError(writingTransaction.getLocation());
            }
            ReadingTransaction readingTransaction = this.readingTransactions.stream().filter(readingTx -> readingTx.singleDbTransaction == writingTransaction).findAny().orElseThrow(() -> new IllegalArgumentException("The supplied transaction has not been registered"));
            if (readingTransaction.readingOnly) {
                throw new IllegalStateException("Upgrading reading-only transaction to a writing one is not allowed");
            }
            this.readingTransactions.remove(readingTransaction);
            this.writingTransaction = readingTransaction.singleDbTransaction;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    @Override
    public void childTransactionTerminated(Status reason) {
        if (this.state != State.OPEN) {
            return;
        }
        this.markForTermination(reason);
    }

    @Override
    public CancellationChecker cancellationChecker() {
        return this::checkTransactionOpenForStatementExecution;
    }

    private FabricException multipleWriteError(Location attempt) {
        return new FabricException((Status)Status.Statement.AccessMode, "Writing to more than one database per transaction is not allowed. Attempted write to %s, currently writing to %s", attempt, this.writingTransaction.getLocation());
    }

    private FabricException commitFailedError() {
        return new FabricException((Status)Status.Transaction.TransactionCommitFailed, "Failed to commit composite transaction %d", this.id);
    }

    private FabricException rollbackFailedError() {
        return new FabricException((Status)Status.Transaction.TransactionRollbackFailed, "Failed to rollback composite transaction %d", this.id);
    }

    public long getId() {
        return this.id;
    }

    public Set<InternalTransaction> getInternalTransactions() {
        return this.localTransactionContext.getInternalTransactions();
    }

    private static enum State {
        OPEN,
        CLOSED,
        TERMINATED;

    }

    private record ErrorRecord(String message, Throwable error) {
    }

    private record ReadingTransaction(SingleDbTransaction singleDbTransaction, boolean readingOnly) {
    }
}

