/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.planning.StatementType;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;

public interface FabricTransaction {
    public void commit();

    public void rollback();

    public StatementResult execute(Function<FabricExecutionContext, StatementResult> var1);

    public void markForTermination(Status var1);

    public Optional<Status> getReasonIfTerminated();

    public FabricTransactionInfo getTransactionInfo();

    public TransactionBookmarkManager getBookmarkManager();

    public void setLastSubmittedStatement(FabricStatementLifecycles.StatementLifecycle var1);

    public Optional<FabricStatementLifecycles.StatementLifecycle> getLastSubmittedStatement();

    public void setMetaData(Map<String, Object> var1);

    public boolean isOpen();

    public Catalog getCatalogSnapshot();

    public CancellationChecker cancellationChecker();

    public static interface FabricExecutionContext {
        public FabricRemoteExecutor.RemoteTransactionContext getRemote();

        public FabricLocalExecutor.LocalTransactionContext getLocal();

        public void validateStatementType(StatementType var1);

        public DatabaseReference getSessionDatabaseReference();

        public Location getOrComputeLocation(Catalog.Graph var1, Supplier<Location> var2);
    }
}

