/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

public class SourceTagging {
    private static final int ID_MAX_BITS = 50;
    private static final long TAG_MAX_VALUE = 16383L;

    public static long makeSourceTag(long sourceId) {
        if (sourceId < 0L || 16383L < sourceId) {
            throw new IllegalArgumentException("Source ids must be in range 0-16383. Got: " + sourceId);
        }
        return SourceTagging.shiftToMsb(sourceId);
    }

    private static long shiftToMsb(long value) {
        return value << 50;
    }

    public static long tagId(long id, long sourceTag) {
        return id | sourceTag;
    }

    public static long extractSourceId(long id) {
        return id >> 50;
    }
}

