/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.pipeline;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.logical.plans.FieldSignature;
import org.neo4j.cypher.internal.logical.plans.FieldSignature$;
import org.neo4j.cypher.internal.logical.plans.ProcedureAccessMode;
import org.neo4j.cypher.internal.logical.plans.ProcedureDbmsAccess$;
import org.neo4j.cypher.internal.logical.plans.ProcedureReadOnlyAccess$;
import org.neo4j.cypher.internal.logical.plans.ProcedureReadWriteAccess$;
import org.neo4j.cypher.internal.logical.plans.ProcedureSchemaWriteAccess$;
import org.neo4j.cypher.internal.logical.plans.ProcedureSignature;
import org.neo4j.cypher.internal.logical.plans.UserFunctionSignature;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.fabric.pipeline.SignatureResolver;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;

public final class SignatureResolver$ {
    public static final SignatureResolver$ MODULE$ = new SignatureResolver$();

    public ProcedureSignature toCypherProcedure(ProcedureHandle handle) {
        org.neo4j.internal.kernel.api.procs.ProcedureSignature signature = handle.signature();
        return new ProcedureSignature(this.asCypherQualifiedName(signature.name()), (IndexedSeq)CollectionConverters$.MODULE$.ListHasAsScala(signature.inputSignature()).asScala().toIndexedSeq().map((Function1 & Serializable)s -> {
            String x$1 = s.name();
            CypherType x$2 = MODULE$.asCypherType(s.neo4jType());
            Option x$3 = MODULE$.OptionalOps(s.defaultValue()).asScala().map((Function1 & Serializable)neo4jValue -> MODULE$.asCypherValue((DefaultParameterValue)neo4jValue));
            boolean x$4 = s.isSensitive();
            boolean x$5 = FieldSignature$.MODULE$.apply$default$4();
            return new FieldSignature(x$1, x$2, x$3, x$5, x$4);
        }), (Option)(signature.isVoid() ? None$.MODULE$ : new Some(CollectionConverters$.MODULE$.ListHasAsScala(signature.outputSignature()).asScala().toIndexedSeq().map((Function1 & Serializable)s -> {
            String x$6 = s.name();
            CypherType x$7 = MODULE$.asCypherType(s.neo4jType());
            boolean x$8 = s.isDeprecated();
            Option x$9 = FieldSignature$.MODULE$.apply$default$3();
            boolean x$10 = FieldSignature$.MODULE$.apply$default$5();
            return new FieldSignature(x$6, x$7, x$9, x$8, x$10);
        }))), this.OptionalOps(signature.deprecated()).asScala(), this.asCypherProcMode(signature.mode()), this.OptionalOps(signature.description()).asScala(), this.OptionalOps(signature.warning()).asScala(), signature.eager(), handle.id(), signature.systemProcedure(), signature.allowedExpiredCredentials());
    }

    public UserFunctionSignature toCypherFunction(UserFunctionHandle fcn) {
        org.neo4j.internal.kernel.api.procs.UserFunctionSignature signature = fcn.signature();
        return new UserFunctionSignature(this.asCypherQualifiedName(signature.name()), (IndexedSeq)CollectionConverters$.MODULE$.ListHasAsScala(signature.inputSignature()).asScala().toIndexedSeq().map((Function1 & Serializable)s -> new FieldSignature(s.name(), MODULE$.asCypherType(s.neo4jType()), MODULE$.OptionalOps(s.defaultValue()).asScala().map((Function1 & Serializable)neo4jValue -> MODULE$.asCypherValue((DefaultParameterValue)neo4jValue)), FieldSignature$.MODULE$.apply$default$4(), FieldSignature$.MODULE$.apply$default$5())), this.asCypherType(signature.outputType()), this.OptionalOps(signature.deprecated()).asScala(), this.OptionalOps(signature.description()).asScala(), false, fcn.id(), fcn.signature().isBuiltIn(), fcn.threadSafe());
    }

    public QualifiedName asKernelQualifiedName(org.neo4j.cypher.internal.logical.plans.QualifiedName name) {
        return new QualifiedName((String[])name.namespace().toArray(ClassTag$.MODULE$.apply(String.class)), name.name());
    }

    public org.neo4j.cypher.internal.logical.plans.QualifiedName asCypherQualifiedName(QualifiedName name) {
        return new org.neo4j.cypher.internal.logical.plans.QualifiedName(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])name.namespace())), name.name());
    }

    private AnyValue asCypherValue(DefaultParameterValue neo4jValue) {
        return ValueUtils.of((Object)neo4jValue.value());
    }

    private CypherType asCypherType(Neo4jTypes.AnyType neoType) {
        CypherType cypherType;
        Neo4jTypes.AnyType anyType = neoType;
        Neo4jTypes.TextType textType = Neo4jTypes.NTString;
        Neo4jTypes.AnyType anyType2 = anyType;
        if (!(textType != null ? !textType.equals(anyType2) : anyType2 != null)) {
            cypherType = (CypherType)package$.MODULE$.CTString();
        } else {
            Neo4jTypes.IntegerType integerType = Neo4jTypes.NTInteger;
            Neo4jTypes.AnyType anyType3 = anyType;
            if (!(integerType != null ? !integerType.equals(anyType3) : anyType3 != null)) {
                cypherType = package$.MODULE$.CTInteger();
            } else {
                Neo4jTypes.FloatType floatType = Neo4jTypes.NTFloat;
                Neo4jTypes.AnyType anyType4 = anyType;
                if (!(floatType != null ? !floatType.equals(anyType4) : anyType4 != null)) {
                    cypherType = package$.MODULE$.CTFloat();
                } else {
                    Neo4jTypes.NumberType numberType = Neo4jTypes.NTNumber;
                    Neo4jTypes.AnyType anyType5 = anyType;
                    if (!(numberType != null ? !numberType.equals(anyType5) : anyType5 != null)) {
                        cypherType = package$.MODULE$.CTNumber();
                    } else {
                        Neo4jTypes.BooleanType booleanType = Neo4jTypes.NTBoolean;
                        Neo4jTypes.AnyType anyType6 = anyType;
                        if (!(booleanType != null ? !booleanType.equals(anyType6) : anyType6 != null)) {
                            cypherType = package$.MODULE$.CTBoolean();
                        } else if (anyType instanceof Neo4jTypes.ListType) {
                            Neo4jTypes.ListType listType = (Neo4jTypes.ListType)anyType;
                            cypherType = package$.MODULE$.CTList(this.asCypherType(listType.innerType()));
                        } else {
                            Neo4jTypes.ByteArrayType byteArrayType = Neo4jTypes.NTByteArray;
                            Neo4jTypes.AnyType anyType7 = anyType;
                            if (!(byteArrayType != null ? !byteArrayType.equals(anyType7) : anyType7 != null)) {
                                cypherType = package$.MODULE$.CTList((CypherType)package$.MODULE$.CTAny());
                            } else {
                                Neo4jTypes.DateTimeType dateTimeType = Neo4jTypes.NTDateTime;
                                Neo4jTypes.AnyType anyType8 = anyType;
                                if (!(dateTimeType != null ? !dateTimeType.equals(anyType8) : anyType8 != null)) {
                                    cypherType = package$.MODULE$.CTDateTime();
                                } else {
                                    Neo4jTypes.LocalDateTimeType localDateTimeType = Neo4jTypes.NTLocalDateTime;
                                    Neo4jTypes.AnyType anyType9 = anyType;
                                    if (!(localDateTimeType != null ? !localDateTimeType.equals(anyType9) : anyType9 != null)) {
                                        cypherType = package$.MODULE$.CTLocalDateTime();
                                    } else {
                                        Neo4jTypes.DateType dateType = Neo4jTypes.NTDate;
                                        Neo4jTypes.AnyType anyType10 = anyType;
                                        if (!(dateType != null ? !dateType.equals(anyType10) : anyType10 != null)) {
                                            cypherType = package$.MODULE$.CTDate();
                                        } else {
                                            Neo4jTypes.TimeType timeType = Neo4jTypes.NTTime;
                                            Neo4jTypes.AnyType anyType11 = anyType;
                                            if (!(timeType != null ? !timeType.equals(anyType11) : anyType11 != null)) {
                                                cypherType = package$.MODULE$.CTTime();
                                            } else {
                                                Neo4jTypes.LocalTimeType localTimeType = Neo4jTypes.NTLocalTime;
                                                Neo4jTypes.AnyType anyType12 = anyType;
                                                if (!(localTimeType != null ? !localTimeType.equals(anyType12) : anyType12 != null)) {
                                                    cypherType = package$.MODULE$.CTLocalTime();
                                                } else {
                                                    Neo4jTypes.DurationType durationType = Neo4jTypes.NTDuration;
                                                    Neo4jTypes.AnyType anyType13 = anyType;
                                                    if (!(durationType != null ? !durationType.equals(anyType13) : anyType13 != null)) {
                                                        cypherType = package$.MODULE$.CTDuration();
                                                    } else {
                                                        Neo4jTypes.PointType pointType = Neo4jTypes.NTPoint;
                                                        Neo4jTypes.AnyType anyType14 = anyType;
                                                        if (!(pointType != null ? !pointType.equals(anyType14) : anyType14 != null)) {
                                                            cypherType = package$.MODULE$.CTPoint();
                                                        } else {
                                                            Neo4jTypes.NodeType nodeType = Neo4jTypes.NTNode;
                                                            Neo4jTypes.AnyType anyType15 = anyType;
                                                            if (!(nodeType != null ? !nodeType.equals(anyType15) : anyType15 != null)) {
                                                                cypherType = package$.MODULE$.CTNode();
                                                            } else {
                                                                Neo4jTypes.RelationshipType relationshipType = Neo4jTypes.NTRelationship;
                                                                Neo4jTypes.AnyType anyType16 = anyType;
                                                                if (!(relationshipType != null ? !relationshipType.equals(anyType16) : anyType16 != null)) {
                                                                    cypherType = package$.MODULE$.CTRelationship();
                                                                } else {
                                                                    Neo4jTypes.PathType pathType = Neo4jTypes.NTPath;
                                                                    Neo4jTypes.AnyType anyType17 = anyType;
                                                                    if (!(pathType != null ? !pathType.equals(anyType17) : anyType17 != null)) {
                                                                        cypherType = package$.MODULE$.CTPath();
                                                                    } else {
                                                                        Neo4jTypes.GeometryType geometryType = Neo4jTypes.NTGeometry;
                                                                        Neo4jTypes.AnyType anyType18 = anyType;
                                                                        if (!(geometryType != null ? !geometryType.equals(anyType18) : anyType18 != null)) {
                                                                            cypherType = package$.MODULE$.CTGeometry();
                                                                        } else {
                                                                            Neo4jTypes.MapType mapType = Neo4jTypes.NTMap;
                                                                            Neo4jTypes.AnyType anyType19 = anyType;
                                                                            if (!(mapType != null ? !mapType.equals(anyType19) : anyType19 != null)) {
                                                                                cypherType = package$.MODULE$.CTMap();
                                                                            } else {
                                                                                Neo4jTypes.AnyType anyType20 = Neo4jTypes.NTAny;
                                                                                Neo4jTypes.AnyType anyType21 = anyType;
                                                                                if (!(anyType20 != null ? !anyType20.equals(anyType21) : anyType21 != null)) {
                                                                                    cypherType = package$.MODULE$.CTAny();
                                                                                } else {
                                                                                    throw new MatchError((Object)anyType);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return cypherType;
    }

    private ProcedureAccessMode asCypherProcMode(Mode mode) {
        ProcedureReadOnlyAccess$ procedureReadOnlyAccess$;
        Mode mode2 = mode;
        if (Mode.READ.equals(mode2)) {
            procedureReadOnlyAccess$ = ProcedureReadOnlyAccess$.MODULE$;
        } else if (Mode.DEFAULT.equals(mode2)) {
            procedureReadOnlyAccess$ = ProcedureReadOnlyAccess$.MODULE$;
        } else if (Mode.WRITE.equals(mode2)) {
            procedureReadOnlyAccess$ = ProcedureReadWriteAccess$.MODULE$;
        } else if (Mode.SCHEMA.equals(mode2)) {
            procedureReadOnlyAccess$ = ProcedureSchemaWriteAccess$.MODULE$;
        } else if (Mode.DBMS.equals(mode2)) {
            procedureReadOnlyAccess$ = ProcedureDbmsAccess$.MODULE$;
        } else {
            throw new CypherExecutionException("Unable to execute procedure, because it requires an unrecognized execution mode: " + mode.name(), null);
        }
        return procedureReadOnlyAccess$;
    }

    private <T> SignatureResolver.OptionalOps<T> OptionalOps(Optional<T> optional) {
        return new SignatureResolver.OptionalOps<T>(optional);
    }

    private SignatureResolver$() {
    }
}

