/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.cypher.internal.CypherQueryObfuscator;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryFactory;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.memory.HeapHighWaterMarkTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class FabricStatementLifecycles {
    private final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;
    private final QueryExecutionMonitor dbmsMonitor;
    private final ExecutingQueryFactory executingQueryFactory;

    public FabricStatementLifecycles(DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, Monitors dbmsMonitors, Config config, SystemNanoClock systemNanoClock) {
        this.databaseContextProvider = databaseContextProvider;
        this.dbmsMonitor = (QueryExecutionMonitor)dbmsMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.executingQueryFactory = new ExecutingQueryFactory(systemNanoClock, FabricStatementLifecycles.setupCpuClockAtomicReference(config));
    }

    private static AtomicReference<CpuClock> setupCpuClockAtomicReference(Config config) {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        SettingChangeListener cpuClockUpdater = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        cpuClockUpdater.accept(null, (Object)((Boolean)config.get(GraphDatabaseSettings.track_query_cpu_time)));
        config.addListener(GraphDatabaseSettings.track_query_cpu_time, cpuClockUpdater);
        return cpuClock;
    }

    StatementLifecycle create(FabricTransactionInfo transactionInfo, String statement, MapValue params) {
        ExecutingQuery executingQuery = this.executingQueryFactory.createUnbound(statement, params, transactionInfo.getClientConnectionInfo(), transactionInfo.getLoginContext().subject().executingUser(), transactionInfo.getLoginContext().subject().authenticatedUser(), transactionInfo.getTxMetadata());
        return new StatementLifecycle(executingQuery);
    }

    public class StatementLifecycle {
        private final ExecutingQuery executingQuery;
        private QueryExecutionMonitor dbMonitor;
        private StatementPhase phase;
        private MonitoringMode monitoringMode;

        private StatementLifecycle(ExecutingQuery executingQuery) {
            this.executingQuery = executingQuery;
            this.phase = StatementPhase.FABRIC;
        }

        void startProcessing() {
            this.getQueryExecutionMonitor().startProcessing(this.executingQuery);
        }

        void doneFabricProcessing(FabricPlan plan) {
            this.executingQuery.onObfuscatorReady(CypherQueryObfuscator.apply((ObfuscationMetadata)plan.obfuscationMetadata()));
            this.monitoringMode = plan.inFabricContext() ? new ParentChildMonitoringMode() : new SingleQueryMonitoringMode();
        }

        void startExecution(Boolean shouldLogIfSingleQuery) {
            this.monitoringMode.startExecution(shouldLogIfSingleQuery);
        }

        void doneFabricPhase() {
            this.phase = StatementPhase.CYPHER;
        }

        void endSuccess() {
            this.phase = StatementPhase.ENDED;
            QueryExecutionMonitor monitor = this.getQueryExecutionMonitor();
            monitor.beforeEnd(this.executingQuery, true);
            monitor.endSuccess(this.executingQuery);
        }

        void endFailure(Throwable failure) {
            this.phase = StatementPhase.ENDED;
            QueryExecutionMonitor monitor = this.getQueryExecutionMonitor();
            monitor.beforeEnd(this.executingQuery, false);
            monitor.endFailure(this.executingQuery, failure.getMessage());
        }

        private QueryExecutionMonitor getQueryExecutionMonitor() {
            return this.getDbMonitor().orElse(FabricStatementLifecycles.this.dbmsMonitor);
        }

        private Optional<QueryExecutionMonitor> getDbMonitor() {
            if (this.dbMonitor == null) {
                this.executingQuery.databaseId().flatMap(arg_0 -> FabricStatementLifecycles.this.databaseContextProvider.getDatabaseContext(arg_0)).map(dbm -> (Monitors)dbm.dependencies().resolveDependency(Monitors.class)).map(monitors -> (QueryExecutionMonitor)monitors.newMonitor(QueryExecutionMonitor.class, new String[0])).ifPresent(monitor -> {
                    this.dbMonitor = monitor;
                });
            }
            return Optional.ofNullable(this.dbMonitor);
        }

        public boolean inFabricPhase() {
            return this.phase == StatementPhase.FABRIC;
        }

        public ExecutingQuery getMonitoredQuery() {
            return this.executingQuery;
        }

        QueryExecutionMonitor getChildQueryMonitor() {
            return this.monitoringMode.getChildQueryMonitor();
        }

        boolean isParentChildMonitoringMode() {
            return this.monitoringMode.isParentChildMonitoringMode();
        }

        private class ParentChildMonitoringMode
        extends MonitoringMode {
            private ParentChildMonitoringMode() {
            }

            @Override
            boolean isParentChildMonitoringMode() {
                return true;
            }

            @Override
            void startExecution(Boolean shouldLogIfSingleQuery) {
                if (!shouldLogIfSingleQuery.booleanValue()) {
                    StatementLifecycle.this.getQueryExecutionMonitor().startExecution(StatementLifecycle.this.executingQuery);
                    StatementLifecycle.this.executingQuery.onCompilationCompleted(null, null);
                    StatementLifecycle.this.executingQuery.onExecutionStarted(HeapHighWaterMarkTracker.NONE);
                }
            }

            @Override
            QueryExecutionMonitor getChildQueryMonitor() {
                return StatementLifecycle.this.getQueryExecutionMonitor();
            }
        }

        private abstract class MonitoringMode {
            private MonitoringMode() {
            }

            abstract boolean isParentChildMonitoringMode();

            abstract QueryExecutionMonitor getChildQueryMonitor();

            abstract void startExecution(Boolean var1);
        }

        private class SingleQueryMonitoringMode
        extends MonitoringMode {
            private SingleQueryMonitoringMode() {
            }

            @Override
            boolean isParentChildMonitoringMode() {
                return false;
            }

            @Override
            void startExecution(Boolean shouldLogIfSingleQuery) {
                if (shouldLogIfSingleQuery.booleanValue()) {
                    StatementLifecycle.this.getQueryExecutionMonitor().startExecution(StatementLifecycle.this.executingQuery);
                }
            }

            @Override
            QueryExecutionMonitor getChildQueryMonitor() {
                return QueryExecutionMonitor.NO_OP;
            }
        }
    }

    public static enum StatementPhase {
        FABRIC,
        CYPHER,
        ENDED;

    }
}

