/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.fabric.bolt.FabricBookmark;
import org.neo4j.fabric.bookmark.BookmarkStateSerializer;

public class FabricBookmarkParser
implements CustomBookmarkFormatParser {
    public boolean isCustomBookmark(String string) {
        return string.startsWith("FB:");
    }

    public List<Bookmark> parse(List<String> customBookmarks) {
        return customBookmarks.stream().map(this::parse).collect(Collectors.toList());
    }

    public FabricBookmark parse(String bookmarkString) {
        if (!this.isCustomBookmark(bookmarkString)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Fabric bookmark", bookmarkString));
        }
        String content = bookmarkString.substring("FB:".length());
        if (content.isEmpty()) {
            return new FabricBookmark(List.of(), List.of());
        }
        return BookmarkStateSerializer.deserialize(content);
    }
}

