/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.fabric.bolt.FabricBookmark;
import org.neo4j.fabric.bolt.FabricBookmarkParser;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.RemoteBookmark;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.Location;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.NamedDatabaseId;

public class TransactionBookmarkManagerImpl
implements TransactionBookmarkManager {
    private final FabricBookmarkParser fabricBookmarkParser = new FabricBookmarkParser();
    private final LocalGraphTransactionIdTracker transactionIdTracker;
    private final boolean multiGraphEverywhere;
    private final Object finalBookmarkLock = new Object();
    private volatile FabricBookmark submittedBookmark;
    private volatile FabricBookmark finalBookmark;

    public TransactionBookmarkManagerImpl(LocalGraphTransactionIdTracker transactionIdTracker, boolean multiGraphEverywhere) {
        this.transactionIdTracker = transactionIdTracker;
        this.multiGraphEverywhere = multiGraphEverywhere;
    }

    @Override
    public void processSubmittedByClient(List<Bookmark> bookmarks) {
        List<FabricBookmark> fabricBookmarks = this.convert(bookmarks);
        this.submittedBookmark = FabricBookmark.merge(fabricBookmarks);
        this.finalBookmark = new FabricBookmark(new ArrayList<FabricBookmark.InternalGraphState>(this.submittedBookmark.getInternalGraphStates()), new ArrayList<FabricBookmark.ExternalGraphState>(this.submittedBookmark.getExternalGraphStates()));
        this.awaitSystemGraphUpToDate();
    }

    private List<FabricBookmark> convert(List<Bookmark> bookmarks) {
        return bookmarks.stream().map(bookmark -> {
            if (bookmark instanceof FabricBookmark) {
                return (FabricBookmark)((Object)bookmark);
            }
            if (!this.multiGraphEverywhere && !bookmark.databaseId().equals((Object)NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID)) {
                throw new FabricException((Status)Status.Transaction.InvalidBookmarkMixture, "Bookmark for unexpected database encountered: " + String.valueOf(bookmark), new Object[0]);
            }
            return TransactionBookmarkManagerImpl.convertNonFabricBookmark(bookmark);
        }).collect(Collectors.toList());
    }

    private static FabricBookmark convertNonFabricBookmark(Bookmark bookmark) {
        UUID databaseUuid = bookmark.databaseId().databaseId().uuid();
        FabricBookmark.InternalGraphState internalGraphState = new FabricBookmark.InternalGraphState(databaseUuid, bookmark.txId());
        return new FabricBookmark(List.of(internalGraphState), List.of());
    }

    private void awaitSystemGraphUpToDate() {
        Map<UUID, Long> graphUuid2TxIdMapping = this.submittedBookmark.getInternalGraphStates().stream().collect(Collectors.toMap(FabricBookmark.InternalGraphState::getGraphUuid, FabricBookmark.InternalGraphState::getTransactionId));
        this.transactionIdTracker.awaitSystemGraphUpToDate(graphUuid2TxIdMapping);
    }

    @Override
    public List<RemoteBookmark> getBookmarksForRemote(Location.Remote location) {
        if (location instanceof Location.Remote.External) {
            return this.submittedBookmark.getExternalGraphStates().stream().filter(egs -> egs.getGraphUuid().equals(location.getUuid())).map(FabricBookmark.ExternalGraphState::getBookmarks).findAny().orElse(List.of());
        }
        return List.of(new RemoteBookmark(this.submittedBookmark.serialize()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remoteTransactionCommitted(Location.Remote location, RemoteBookmark bookmark) {
        if (bookmark == null) {
            return;
        }
        Object object = this.finalBookmarkLock;
        synchronized (object) {
            if (location instanceof Location.Remote.External) {
                FabricBookmark.ExternalGraphState externalGraphState = new FabricBookmark.ExternalGraphState(location.getUuid(), List.of(bookmark));
                FabricBookmark bookmarkUpdate = new FabricBookmark(List.of(), List.of(externalGraphState));
                this.finalBookmark = FabricBookmark.merge(List.of(this.finalBookmark, bookmarkUpdate));
            } else {
                FabricBookmark fabricBookmark = this.fabricBookmarkParser.parse(bookmark.getSerialisedState());
                this.finalBookmark = FabricBookmark.merge(List.of(this.finalBookmark, fabricBookmark));
            }
        }
    }

    @Override
    public void awaitUpToDate(Location.Local location) {
        this.submittedBookmark.getInternalGraphStates().stream().filter(egs -> egs.getGraphUuid().equals(location.getUuid())).map(FabricBookmark.InternalGraphState::getTransactionId).findAny().ifPresent(transactionId -> this.transactionIdTracker.awaitGraphUpToDate(location, (long)transactionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localTransactionCommitted(Location.Local location) {
        Object object = this.finalBookmarkLock;
        synchronized (object) {
            long transactionId = this.transactionIdTracker.getTransactionId(location);
            FabricBookmark.InternalGraphState internalGraphState = new FabricBookmark.InternalGraphState(location.getUuid(), transactionId);
            FabricBookmark bookmarkUpdate = new FabricBookmark(List.of(internalGraphState), List.of());
            this.finalBookmark = FabricBookmark.merge(List.of(this.finalBookmark, bookmarkUpdate));
        }
    }

    @Override
    public FabricBookmark constructFinalBookmark() {
        return this.finalBookmark;
    }
}

