/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.config.FabricSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public abstract class FabricDatabaseManager {
    private final boolean multiGraphEverywhere;
    private final DatabaseReferenceRepository databaseReferenceRepo;
    private final DatabaseManager<? extends DatabaseContext> databaseManager;

    public FabricDatabaseManager(FabricConfig fabricConfig, DatabaseManager<? extends DatabaseContext> databaseManager, DatabaseReferenceRepository databaseReferenceRepo) {
        this.databaseManager = databaseManager;
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.multiGraphEverywhere = fabricConfig.isEnabledByDefault();
    }

    public static boolean fabricByDefault(Config config) {
        return (Boolean)config.get(FabricSettings.enabled_by_default);
    }

    public DatabaseReferenceRepository databaseReferenceRepository() {
        return this.databaseReferenceRepo;
    }

    public boolean hasMultiGraphCapabilities(String databaseNameRaw) {
        return this.multiGraphCapabilitiesEnabledForAllDatabases() || this.isFabricDatabase(databaseNameRaw);
    }

    public boolean multiGraphCapabilitiesEnabledForAllDatabases() {
        return this.multiGraphEverywhere;
    }

    public GraphDatabaseFacade getDatabaseFacade(String databaseNameRaw) throws UnavailableException {
        DatabaseContext databaseContext = (DatabaseContext)this.databaseReferenceRepo.getInternalByName(databaseNameRaw).map(DatabaseReference.Internal::databaseId).flatMap(arg_0 -> this.databaseManager.getDatabaseContext(arg_0)).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
        databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        return databaseContext.databaseFacade();
    }

    public DatabaseReference getDatabaseReference(String databaseNameRaw) throws UnavailableException {
        DatabaseReference ref = (DatabaseReference)this.databaseReferenceRepo.getByName(databaseNameRaw).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
        boolean isInternal = ref instanceof DatabaseReference.Internal;
        if (isInternal) {
            this.assertInternalDatabaseAvailable((DatabaseReference.Internal)ref);
        }
        return ref;
    }

    private void assertInternalDatabaseAvailable(DatabaseReference.Internal databaseReference) throws UnavailableException {
        DatabaseContext ctx = (DatabaseContext)this.databaseManager.getDatabaseContext(databaseReference.databaseId()).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseReference.alias().name()));
        ctx.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> new DatabaseNotFoundException("Database " + databaseNameRaw + " not found");
    }

    public abstract boolean isFabricDatabasePresent();

    public abstract void manageFabricDatabases(GraphDatabaseService var1, boolean var2);

    public abstract boolean isFabricDatabase(String var1);

    public static class Community
    extends FabricDatabaseManager {
        public Community(FabricConfig fabricConfig, DatabaseManager<? extends DatabaseContext> databaseManager, DatabaseReferenceRepository databaseReferenceRepo) {
            super(fabricConfig, databaseManager, databaseReferenceRepo);
        }

        @Override
        public boolean isFabricDatabasePresent() {
            return false;
        }

        @Override
        public void manageFabricDatabases(GraphDatabaseService system, boolean update) {
        }

        @Override
        public boolean isFabricDatabase(String databaseNameRaw) {
            return false;
        }
    }
}

