/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.cache;

import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.LFUCache;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u000b\u0017\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)A\u0007\u0001C\u0001k\u0015!!\b\u0001\u0001<\u000b\u00111\u0005\u0001A$\u0006\t=\u0003\u0001\u0001U\u0003\u0005?\u0002\u00011(\u0002\u0003a\u0001\u0001\tW\u0001\u00025\u0001\u0001%Dqa\u0006\u0001C\u0002\u0013%q\u000e\u0003\u0004v\u0001\u0001\u0006I\u0001\u001d\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u001dY\b\u00011A\u0005\nqDq!!\u0002\u0001A\u0003&\u0001\u0010\u0003\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003x\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0004\u0002\u0010\u0001\u0001\u000b\u0015\u0002=\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!1\u0011Q\b\u0001\u0005\u0002]Da!a\u0010\u0001\t\u00039(\u0001\u0005$bEJL7-U;fef\u001c\u0015m\u00195f\u0015\t9\u0002$A\u0003dC\u000eDWM\u0003\u0002\u001a5\u00051a-\u00192sS\u000eT!a\u0007\u000f\u0002\u000b9,w\u000e\u000e6\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u00031\u0019\u0017m\u00195f\r\u0006\u001cGo\u001c:z!\tAc&D\u0001*\u0015\t9\"F\u0003\u0002,Y\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002.5\u000511-\u001f9iKJL!aL\u0015\u0003)\r\u000bgMZ3j]\u0016\u001c\u0015m\u00195f\r\u0006\u001cGo\u001c:z\u0003\u0011\u0019\u0018N_3\u0011\u0005\u0005\u0012\u0014BA\u001a#\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007YB\u0014\b\u0005\u00028\u00015\ta\u0003C\u0003'\u0007\u0001\u0007q\u0005C\u00031\u0007\u0001\u0007\u0011GA\u0003Rk\u0016\u0014\u0018\u0010\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}\tj\u0011a\u0010\u0006\u0003\u0001z\ta\u0001\u0010:p_Rt\u0014B\u0001\"#\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0013#A\u0002)be\u0006l7\u000f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u00069a/\u001b:uk\u0006d'B\u0001'\u001b\u0003\u00191\u0018\r\\;fg&\u0011a*\u0013\u0002\t\u001b\u0006\u0004h+\u00197vK\nQ\u0001+\u0019:b[RK\b/Z:\u0011\u0005EcfB\u0001*[\u001d\t\u0019\u0016L\u0004\u0002U1:\u0011Qk\u0016\b\u0003}YK\u0011!H\u0005\u00037qI!!\f\u000e\n\u0005-b\u0013BA.+\u0003)\tV/\u001a:z\u0007\u0006\u001c\u0007.Z\u0005\u0003;z\u0013\u0001\u0003U1sC6,G/\u001a:UsB,W*\u00199\u000b\u0005mS#A\u0005#fM\u0006,H\u000e^\"p]R,\u0007\u0010\u001e(b[\u0016\u00141aS3z!\u0015\t#\r\u001a4h\u0013\t\u0019'E\u0001\u0004UkBdWm\r\t\u0003K\u0012i\u0011\u0001\u0001\t\u0003K\u001a\u0001\"!Z\u0004\u0003\u000bY\u000bG.^3\u0011\u0005)lW\"A6\u000b\u00051D\u0012\u0001\u00039mC:t\u0017N\\4\n\u00059\\'A\u0003$bEJL7\r\u00157b]V\t\u0001\u000f\u0005\u0003)cN$\u0018B\u0001:*\u0005!ae)V\"bG\",\u0007CA3\t!\t)\u0017\"\u0001\u0004dC\u000eDW\rI\u0001\u0005Q&$8/F\u0001y!\t\t\u00130\u0003\u0002{E\t!Aj\u001c8h\u0003!A\u0017\u000e^:`I\u0015\fHcA?\u0002\u0002A\u0011\u0011E`\u0005\u0003\u007f\n\u0012A!\u00168ji\"A\u00111A\u0007\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nQ\u0001[5ug\u0002\na!\\5tg\u0016\u001c\u0018AC7jgN,7o\u0018\u0013fcR\u0019Q0!\u0004\t\u0011\u0005\r\u0001#!AA\u0002a\fq!\\5tg\u0016\u001c\b%A\bd_6\u0004X\u000f^3JM\u0006\u00137/\u001a8u)-I\u0017QCA\r\u0003?\t\u0019#!\f\t\r\u0005]!\u00031\u0001e\u0003\u0015\tX/\u001a:z\u0011\u001d\tYB\u0005a\u0001\u0003;\ta\u0001]1sC6\u001c\bCA3\u0006\u0011\u0019\t\tC\u0005a\u0001O\u0006\u0011B-\u001a4bk2$8i\u001c8uKb$h*Y7f\u0011\u001d\t)C\u0005a\u0001\u0003O\tqaY8naV$X\r\u0005\u0003\"\u0003SI\u0017bAA\u0016E\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003_\u0011\u0002\u0019AA\u0019\u0003-\u0019\bn\\;mI\u000e\u000b7\r[3\u0011\r\u0005\n\u0019$[A\u001c\u0013\r\t)D\t\u0002\n\rVt7\r^5p]F\u00022!IA\u001d\u0013\r\tYD\t\u0002\b\u0005>|G.Z1o\u0003\u001d9W\r\u001e%jiN\f\u0011bZ3u\u001b&\u001c8/Z:")
public class FabricQueryCache {
    private final LFUCache<Tuple3<String, QueryCache.ParameterTypeMap, String>, FabricPlan> cache;
    private long hits;
    private long misses;

    private LFUCache<Tuple3<String, QueryCache.ParameterTypeMap, String>, FabricPlan> cache() {
        return this.cache;
    }

    private long hits() {
        return this.hits;
    }

    private void hits_$eq(long x$1) {
        this.hits = x$1;
    }

    private long misses() {
        return this.misses;
    }

    private void misses_$eq(long x$1) {
        this.misses = x$1;
    }

    public FabricPlan computeIfAbsent(String query, MapValue params, String defaultContextName, Function0<FabricPlan> compute, Function1<FabricPlan, Object> shouldCache) {
        FabricPlan fabricPlan;
        QueryCache.ParameterTypeMap paramTypes = QueryCache$.MODULE$.extractParameterTypeMap(params);
        Tuple3 key = new Tuple3((Object)query, (Object)paramTypes, (Object)defaultContextName);
        Option option = this.cache().get((Object)key);
        if (None$.MODULE$.equals(option)) {
            FabricPlan result = (FabricPlan)compute.apply();
            if (BoxesRunTime.unboxToBoolean((Object)shouldCache.apply((Object)result))) {
                this.cache().put((Object)key, (Object)result);
            }
            this.misses_$eq(this.misses() + 1L);
            fabricPlan = result;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            FabricPlan result = (FabricPlan)some.value();
            this.hits_$eq(this.hits() + 1L);
            fabricPlan = result;
        } else {
            throw new MatchError((Object)option);
        }
        return fabricPlan;
    }

    public long getHits() {
        return this.hits();
    }

    public long getMisses() {
        return this.misses();
    }

    public FabricQueryCache(CaffeineCacheFactory cacheFactory, int size) {
        this.cache = new LFUCache(cacheFactory, size);
        this.hits = 0L;
        this.misses = 0L;
    }
}

