/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class FabricException
extends RuntimeException
implements Status.HasStatus,
HasQuery {
    private final Status statusCode;
    private Long queryId;

    public FabricException(Status statusCode, Throwable cause) {
        super(cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    public FabricException(Status statusCode, String message, Object ... parameters) {
        super(String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    public FabricException(Status statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    public FabricException(Status statusCode, String message, Throwable cause, Long queryId) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = queryId;
    }

    public Status status() {
        return this.statusCode;
    }

    public Long query() {
        return this.queryId;
    }

    public void setQuery(Long queryId) {
        this.queryId = queryId;
    }
}

