/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class ErrorReporter {
    private final Log userLog;
    private final Log debugLog;

    public ErrorReporter(LogService logging) {
        this.userLog = logging.getUserLog(ErrorReporter.class);
        this.debugLog = logging.getInternalLog(ErrorReporter.class);
    }

    public void report(String message, Throwable error, Status defaultStatus) {
        Status status = defaultStatus;
        if (error instanceof Status.HasStatus) {
            status = ((Status.HasStatus)error).status();
        }
        if (status.code().classification() == Status.Classification.DatabaseError) {
            String logMessage = String.format("Unexpected error [%s]: %s.", status.code().serialize(), message);
            this.userLog.error(logMessage);
            this.debugLog.error(logMessage, error);
        }
    }
}

