/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.kernel.database.NamedDatabaseId;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00114qa\u0003\u0007\u0011\u0002G\u0005Q\u0003C\u0003\u001d\u0001\u0019\u0005Q\u0004C\u00032\u0001\u0019\u0005!gB\u0003A\u0019!\u0005\u0011IB\u0003\f\u0019!\u00051\tC\u0003E\t\u0011\u0005QI\u0002\u0003G\t\u00019\u0005\u0002C%\u0007\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000b\u00113A\u0011\u00010\t\u000bq1A\u0011A\u000f\t\u000bE2A\u0011\u00012\u0003\u001d\u0011\u000bG/\u00192bg\u0016dun\\6va*\u0011QBD\u0001\u0005KZ\fGN\u0003\u0002\u0010!\u00051a-\u00192sS\u000eT!!\u0005\n\u0002\u000b9,w\u000e\u000e6\u000b\u0003M\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g\u0003-!\u0017\r^1cCN,\u0017\nZ:\u0016\u0003y\u00012a\b\u0014*\u001d\t\u0001C\u0005\u0005\u0002\"15\t!E\u0003\u0002$)\u00051AH]8pizJ!!\n\r\u0002\rA\u0013X\rZ3g\u0013\t9\u0003FA\u0002TKRT!!\n\r\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00033bi\u0006\u0014\u0017m]3\u000b\u00059\u0002\u0012AB6fe:,G.\u0003\u00021W\tya*Y7fI\u0012\u000bG/\u00192bg\u0016LE-\u0001\u0006eCR\f'-Y:f\u0013\u0012$\"a\r\u001c\u0011\u0007]!\u0014&\u0003\u000261\t1q\n\u001d;j_:DQa\u000e\u0002A\u0002a\nA\u0002Z1uC\n\f7/\u001a(b[\u0016\u0004\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u000f!,G\u000e]3sg*\u0011Q\bE\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005}R$A\u0006(pe6\fG.\u001b>fI\u0012\u000bG/\u00192bg\u0016t\u0015-\\3\u0002\u001d\u0011\u000bG/\u00192bg\u0016dun\\6vaB\u0011!\tB\u0007\u0002\u0019M\u0011AAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0013q\u0001R3gCVdGoE\u0002\u0007-!\u0003\"A\u0011\u0001\u0002\u001f\u0011\fG/\u00192bg\u0016l\u0015M\\1hKJ\u00042a\u0013*U\u001b\u0005a%BA'O\u0003!1WO\\2uS>t'BA(Q\u0003\u0011)H/\u001b7\u000b\u0003E\u000bAA[1wC&\u00111\u000b\u0014\u0002\t'V\u0004\b\u000f\\5feB\u0019Q+W.\u000e\u0003YS!\u0001L,\u000b\u0005a\u0003\u0012\u0001\u00023c[NL!A\u0017,\u0003\u001f\u0011\u000bG/\u00192bg\u0016l\u0015M\\1hKJ\u0004\"!\u0016/\n\u0005u3&a\u0004#bi\u0006\u0014\u0017m]3D_:$X\r\u001f;\u0015\u0005}\u000b\u0007C\u00011\u0007\u001b\u0005!\u0001\"B%\t\u0001\u0004QECA\u001ad\u0011\u00159$\u00021\u00019\u0001")
public interface DatabaseLookup {
    public Set<NamedDatabaseId> databaseIds();

    public Option<NamedDatabaseId> databaseId(NormalizedDatabaseName var1);

    public static class Default
    implements DatabaseLookup {
        private final Supplier<DatabaseManager<DatabaseContext>> databaseManager;

        @Override
        public Set<NamedDatabaseId> databaseIds() {
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.databaseManager.get().registeredDatabases().keySet()).asScala()).toSet();
        }

        @Override
        public Option<NamedDatabaseId> databaseId(NormalizedDatabaseName databaseName) {
            Optional maybeDatabaseId = this.databaseManager.get().databaseIdRepository().getByName(databaseName);
            return maybeDatabaseId.isPresent() ? new Some(maybeDatabaseId.get()) : None$.MODULE$;
        }

        public Default(Supplier<DatabaseManager<DatabaseContext>> databaseManager) {
            this.databaseManager = databaseManager;
        }
    }
}

