/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.util.FeatureToggles;

public abstract class FabricDatabaseManager {
    public static final String FABRIC_BY_DEFAULT_FLAG_NAME = "fabric_by_default";
    public static final boolean FABRIC_BY_DEFAULT_DEFAULT_VALUE = true;
    private final DatabaseManager<DatabaseContext> databaseManager;
    private final DatabaseIdRepository databaseIdRepository;
    private final boolean multiGraphEverywhere = FabricDatabaseManager.fabricByDefault();

    public FabricDatabaseManager(DatabaseManager<DatabaseContext> databaseManager) {
        this.databaseManager = databaseManager;
        this.databaseIdRepository = databaseManager.databaseIdRepository();
    }

    public static boolean fabricByDefault() {
        return FeatureToggles.flag(FabricDatabaseManager.class, (String)FABRIC_BY_DEFAULT_FLAG_NAME, (boolean)true);
    }

    public DatabaseIdRepository databaseIdRepository() {
        return this.databaseIdRepository;
    }

    public boolean hasMultiGraphCapabilities(String databaseNameRaw) {
        return this.multiGraphCapabilitiesEnabledForAllDatabases() || this.isFabricDatabase(databaseNameRaw);
    }

    public boolean multiGraphCapabilitiesEnabledForAllDatabases() {
        return this.multiGraphEverywhere;
    }

    public GraphDatabaseFacade getDatabase(String databaseNameRaw) throws UnavailableException {
        DatabaseContext databaseContext = (DatabaseContext)this.databaseIdRepository.getByName(databaseNameRaw).flatMap(arg_0 -> this.databaseManager.getDatabaseContext(arg_0)).orElseThrow(() -> new DatabaseNotFoundException("Database " + databaseNameRaw + " not found"));
        databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        return databaseContext.databaseFacade();
    }

    public abstract boolean isFabricDatabasePresent();

    public abstract void manageFabricDatabases(GraphDatabaseService var1, boolean var2);

    public abstract boolean isFabricDatabase(String var1);

    public static class Community
    extends FabricDatabaseManager {
        public Community(DatabaseManager<DatabaseContext> databaseManager) {
            super(databaseManager);
        }

        @Override
        public boolean isFabricDatabasePresent() {
            return false;
        }

        @Override
        public void manageFabricDatabases(GraphDatabaseService system, boolean update) {
        }

        @Override
        public boolean isFabricDatabase(String databaseNameRaw) {
            return false;
        }
    }
}

