/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.util;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.CatalogDDL;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.semantics.FeatureError;
import org.neo4j.cypher.internal.ast.semantics.SemanticError;
import org.neo4j.cypher.internal.ast.semantics.SemanticErrorDef;
import org.neo4j.cypher.internal.util.ASTNode;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.DatabaseAdministrationException;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.util.Errors;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.Nothing$;

public final class Errors$ {
    public static Errors$ MODULE$;

    static {
        new Errors$();
    }

    public SemanticError openCypherSemantic(String msg, ASTNode node) {
        return new SemanticError(msg, node.position());
    }

    public void openCypherInvalidOnError(Seq<SemanticErrorDef> errors) {
        if (errors.nonEmpty()) {
            throw this.openCypherInvalid(errors);
        }
    }

    public Nothing$ openCypherInvalid(Seq<SemanticErrorDef> errors) {
        throw new Errors.InvalidQueryException(errors);
    }

    public Nothing$ openCypherInvalid(SemanticErrorDef error) {
        return this.openCypherInvalid((Seq<SemanticErrorDef>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticErrorDef[]{error}))));
    }

    public Nothing$ openCypherFailure(Seq<SemanticErrorDef> errors) {
        throw new Errors.EvaluationFailedException(errors);
    }

    public Nothing$ openCypherFailure(SemanticErrorDef error) {
        return this.openCypherFailure((Seq<SemanticErrorDef>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticErrorDef[]{error}))));
    }

    public Nothing$ openCypherUnexpected(String exp, InputPosition pos) {
        return this.openCypherInvalid((SemanticErrorDef)new SemanticError(new StringBuilder(10).append("Expected: ").append(exp).toString(), pos));
    }

    public Nothing$ openCypherUnexpected(String exp, String got, InputPosition pos) {
        return this.openCypherInvalid((SemanticErrorDef)new SemanticError(new StringBuilder(17).append("Expected: ").append(exp).append(", got: ").append(got).toString(), pos));
    }

    public Nothing$ openCypherUnexpected(String exp, String got, String in, InputPosition pos) {
        return this.openCypherInvalid((SemanticErrorDef)new SemanticError(new StringBuilder(23).append("Expected: ").append(exp).append(", got: ").append(got).append(", in: ").append(in).toString(), pos));
    }

    public Nothing$ openCypherUnexpected(String exp, ASTNode got) {
        return this.openCypherUnexpected(exp, got.position());
    }

    public Nothing$ openCypherUnknownFunction(String qualifiedName, InputPosition pos) {
        return this.openCypherFailure((SemanticErrorDef)new SemanticError(new StringBuilder(19).append("Unknown function '").append(qualifiedName).append("'").toString(), pos));
    }

    public Nothing$ wrongType(String exp, String got) {
        throw new CypherTypeException(new StringBuilder(27).append("Wrong type. Expected ").append(exp).append(", got ").append(got).toString());
    }

    public Nothing$ wrongArity(int exp, int got, InputPosition pos) {
        return this.syntax(new StringBuilder(52).append("Wrong arity. Expected ").append(exp).append(" argument(s), got ").append(got).append(" argument(s)").toString());
    }

    public Nothing$ syntax(String msg) {
        throw new SyntaxException(msg);
    }

    public Nothing$ syntax(String msg, String query, InputPosition pos) {
        throw new SyntaxException(msg, query, pos.offset());
    }

    public Nothing$ semantic(String message) {
        throw new InvalidSemanticsException(message);
    }

    public Nothing$ ddlNotSupported(CatalogDDL ddl) {
        throw new DatabaseAdministrationException(new StringBuilder(89).append("This is an administration command and it should be executed against the system database: ").append(ddl.name()).toString());
    }

    public Nothing$ notSupported(String feature) {
        return this.semantic(new StringBuilder(27).append(feature).append(" is not supported in Fabric").toString());
    }

    public Nothing$ entityNotFound(String kind, String needle) {
        throw new EntityNotFoundException(new StringBuilder(12).append(kind).append(" not found: ").append(needle).toString());
    }

    public <T> T errorContext(String query, ASTNode node, Function0<T> block) {
        Object object;
        try {
            object = block.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof Errors.HasErrors) {
                Errors.HasErrors hasErrors = (Errors.HasErrors)((Object)throwable2);
                throw (Throwable)((Object)hasErrors.update((Function1<SemanticErrorDef, SemanticErrorDef>)(Function1 & Serializable & scala.Serializable)x0$1 -> {
                    boolean bl = false;
                    SemanticError semanticError = null;
                    boolean bl2 = false;
                    FeatureError featureError = null;
                    SemanticErrorDef semanticErrorDef = x0$1;
                    if (semanticErrorDef instanceof SemanticError) {
                        bl = true;
                        semanticError = (SemanticError)semanticErrorDef;
                        String msg = semanticError.msg();
                        InputPosition inputPosition = semanticError.position();
                        InputPosition inputPosition2 = InputPosition$.MODULE$.NONE();
                        InputPosition inputPosition3 = inputPosition;
                        if (!(inputPosition2 != null ? !inputPosition2.equals(inputPosition3) : inputPosition3 != null)) {
                            throw MODULE$.syntax(msg, query, node.position());
                        }
                    }
                    if (bl) {
                        String msg = semanticError.msg();
                        InputPosition pos = semanticError.position();
                        throw MODULE$.syntax(msg, query, pos);
                    }
                    if (semanticErrorDef instanceof FeatureError) {
                        bl2 = true;
                        featureError = (FeatureError)semanticErrorDef;
                        String msg = featureError.msg();
                        InputPosition inputPosition = featureError.position();
                        InputPosition inputPosition4 = InputPosition$.MODULE$.NONE();
                        InputPosition inputPosition5 = inputPosition;
                        if (!(inputPosition4 != null ? !inputPosition4.equals(inputPosition5) : inputPosition5 != null)) {
                            throw MODULE$.syntax(msg, query, node.position());
                        }
                    }
                    if (bl2) {
                        String msg = featureError.msg();
                        InputPosition pos = featureError.position();
                        throw MODULE$.syntax(msg, query, pos);
                    }
                    SemanticErrorDef semanticErrorDef2 = semanticErrorDef;
                    return semanticErrorDef2;
                }));
            }
            throw throwable;
        }
        return (T)object;
    }

    public String show(CatalogName n) {
        return n.parts().mkString(".");
    }

    public String show(AnyValue av) {
        String string;
        AnyValue anyValue = av;
        if (anyValue instanceof Value) {
            Value value = (Value)anyValue;
            string = value.prettyPrint();
        } else {
            string = anyValue.getTypeName();
        }
        return string;
    }

    public String show(Catalog.Arg<?> a) {
        return new StringBuilder(2).append(a.name()).append(": ").append(a.tpe().getSimpleName()).toString();
    }

    public String show(Seq<?> seq) {
        return ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof AnyValue) {
                AnyValue anyValue = (AnyValue)object;
                string = MODULE$.show(anyValue);
            } else if (object instanceof Catalog.Arg) {
                Catalog.Arg arg = (Catalog.Arg)object;
                string = MODULE$.show(arg);
            } else {
                throw new MatchError(object);
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    private Errors$() {
        MODULE$ = this;
    }
}

