/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.fabric.executor.Location;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;

public class LocalGraphTransactionIdTracker {
    private final TransactionIdTracker transactionIdTracker;
    private final DatabaseIdRepository databaseIdRepository;
    private final Duration bookmarkTimeout;

    public LocalGraphTransactionIdTracker(TransactionIdTracker transactionIdTracker, DatabaseIdRepository databaseIdRepository, Duration bookmarkTimeout) {
        this.transactionIdTracker = transactionIdTracker;
        this.databaseIdRepository = databaseIdRepository;
        this.bookmarkTimeout = bookmarkTimeout;
    }

    public void awaitSystemGraphUpToDate(long transactionId) {
        this.transactionIdTracker.awaitUpToDate(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID, transactionId, this.bookmarkTimeout);
    }

    public void awaitSystemGraphUpToDate(Map<UUID, Long> graphUuid2TxIdMapping) {
        Long systemDbTxId = graphUuid2TxIdMapping.get(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID.databaseId().uuid());
        if (systemDbTxId != null) {
            this.awaitSystemGraphUpToDate(systemDbTxId);
        }
    }

    public void awaitGraphUpToDate(Location.Local location, long transactionId) {
        NamedDatabaseId namedDatabaseId = this.getNamedDatabaseId(location);
        this.transactionIdTracker.awaitUpToDate(namedDatabaseId, transactionId, this.bookmarkTimeout);
    }

    public long getTransactionId(Location.Local location) {
        NamedDatabaseId namedDatabaseId = this.getNamedDatabaseId(location);
        return this.transactionIdTracker.newestTransactionId(namedDatabaseId);
    }

    private NamedDatabaseId getNamedDatabaseId(Location.Local location) {
        DatabaseId databaseId = DatabaseIdFactory.from((UUID)location.getUuid());
        Optional namedDatabaseId = this.databaseIdRepository.getById(databaseId);
        if (namedDatabaseId.isEmpty()) {
            throw new IllegalArgumentException("A local graph could not be mapped to a database");
        }
        return (NamedDatabaseId)namedDatabaseId.get();
    }
}

