/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.transaction.FabricTransactionImpl;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.logging.internal.LogService;
import org.neo4j.time.SystemNanoClock;

public class FabricTransactionMonitor
extends TransactionMonitor {
    private final Map<FabricTransactionImpl, TransactionMonitor.MonitoredTransaction> transactions = new ConcurrentHashMap<FabricTransactionImpl, TransactionMonitor.MonitoredTransaction>();
    private final SystemNanoClock clock;
    private final FabricConfig fabricConfig;

    public FabricTransactionMonitor(SystemNanoClock clock, LogService logService, FabricConfig fabricConfig) {
        super(clock, logService);
        this.clock = clock;
        this.fabricConfig = fabricConfig;
    }

    public void startMonitoringTransaction(FabricTransactionImpl transaction, FabricTransactionInfo transactionInfo) {
        long startTimeNanos = this.clock.nanos();
        long timeoutNanos = transactionInfo.getTxTimeout() != null ? transactionInfo.getTxTimeout().toNanos() : this.fabricConfig.getTransactionTimeout().toNanos();
        this.transactions.put(transaction, new FabricMonitoredTransaction(transaction, startTimeNanos, timeoutNanos));
    }

    public void stopMonitoringTransaction(FabricTransactionImpl transaction) {
        this.transactions.remove(transaction);
    }

    protected Set<TransactionMonitor.MonitoredTransaction> getActiveTransactions() {
        return new HashSet<TransactionMonitor.MonitoredTransaction>(this.transactions.values());
    }

    private static class FabricMonitoredTransaction
    implements TransactionMonitor.MonitoredTransaction {
        private final FabricTransactionImpl fabricTransaction;
        private final long startTimeNanos;
        private final long timeoutNanos;

        FabricMonitoredTransaction(FabricTransactionImpl fabricTransaction, long startTimeNanos, long timeoutNanos) {
            this.fabricTransaction = fabricTransaction;
            this.startTimeNanos = startTimeNanos;
            this.timeoutNanos = timeoutNanos;
        }

        public long startTimeNanos() {
            return this.startTimeNanos;
        }

        public long timeoutNanos() {
            return this.timeoutNanos;
        }

        public boolean isSchemaTransaction() {
            return this.fabricTransaction.isSchemaTransaction();
        }

        public boolean markForTermination(Status reason) {
            this.fabricTransaction.markForTermination(reason);
            return true;
        }

        public String getIdentifyingDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("QueryRouterTransaction[");
            sb.append("id=").append(this.fabricTransaction.getId()).append(",");
            String rawAddress = this.fabricTransaction.getTransactionInfo().getClientConnectionInfo().clientAddress();
            String address = rawAddress == null ? "embedded" : rawAddress;
            sb.append("clientAddress=").append(address);
            AuthSubject authSubject = this.fabricTransaction.getTransactionInfo().getLoginContext().subject();
            if (authSubject != AuthSubject.ANONYMOUS && authSubject != AuthSubject.AUTH_DISABLED) {
                sb.append(",").append("username=").append(authSubject.username());
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

