/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.fabric.executor.Location;
import org.neo4j.graphdb.ExecutionPlanDescription;

public class RemoteExecutionPlanDescription
implements ExecutionPlanDescription {
    private final ExecutionPlanDescription remotePlanDescription;
    private final Location.Remote location;
    private final ExecutionPlanDescription.ProfilerStatistics profilerStatistics;

    RemoteExecutionPlanDescription(ExecutionPlanDescription remotePlanDescription, Location.Remote location) {
        this.remotePlanDescription = remotePlanDescription;
        this.location = location;
        this.profilerStatistics = remotePlanDescription.hasProfilerStatistics() ? new ProfilerStatisticsWrapper(remotePlanDescription.getProfilerStatistics()) : null;
    }

    public String getName() {
        return "RemoteExecution@graph(" + this.location.getGraphId() + ")";
    }

    public List<ExecutionPlanDescription> getChildren() {
        return List.of(this.remotePlanDescription);
    }

    public Map<String, Object> getArguments() {
        return this.remotePlanDescription.getArguments();
    }

    public Set<String> getIdentifiers() {
        return this.remotePlanDescription.getIdentifiers();
    }

    public boolean hasProfilerStatistics() {
        return this.remotePlanDescription.hasProfilerStatistics();
    }

    public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
        return this.profilerStatistics;
    }

    private static class ProfilerStatisticsWrapper
    implements ExecutionPlanDescription.ProfilerStatistics {
        private final ExecutionPlanDescription.ProfilerStatistics childStatistics;

        ProfilerStatisticsWrapper(ExecutionPlanDescription.ProfilerStatistics childStatistics) {
            this.childStatistics = childStatistics;
        }

        public boolean hasRows() {
            return this.childStatistics.hasRows();
        }

        public long getRows() {
            return this.childStatistics.getRows();
        }

        public boolean hasDbHits() {
            return this.childStatistics.hasDbHits();
        }

        public long getDbHits() {
            return 0L;
        }

        public boolean hasPageCacheStats() {
            return this.childStatistics.hasPageCacheStats();
        }

        public long getPageCacheHits() {
            return 0L;
        }

        public long getPageCacheMisses() {
            return 0L;
        }

        public boolean hasTime() {
            return false;
        }

        public long getTime() {
            return 0L;
        }
    }
}

