/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.cypher.internal.CypherDeprecationNotificationsProvider;
import org.neo4j.cypher.internal.CypherQueryObfuscator;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.transaction.StatementLifecycleTransactionInfo;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.DeprecationNotificationsProvider;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.ExecutingQueryFactory;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.lock.LockTracer;
import org.neo4j.memory.HeapHighWaterMarkTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class QueryStatementLifecycles {
    private final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;
    private final QueryExecutionMonitor dbmsMonitor;
    private final ExecutingQueryFactory executingQueryFactory;
    private final boolean shardQueryLogEnabled;

    public QueryStatementLifecycles(DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, Monitors dbmsMonitors, Config config, LockTracer systemLockTracer, SystemNanoClock systemNanoClock) {
        this.databaseContextProvider = databaseContextProvider;
        this.dbmsMonitor = (QueryExecutionMonitor)dbmsMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.executingQueryFactory = new ExecutingQueryFactory(systemNanoClock, QueryStatementLifecycles.setupCpuClockAtomicReference(config), systemLockTracer);
        this.shardQueryLogEnabled = (Boolean)config.get(GraphDatabaseInternalSettings.shard_query_log_enabled);
    }

    private static AtomicReference<CpuClock> setupCpuClockAtomicReference(Config config) {
        AtomicReference<CpuClock> cpuClock = new AtomicReference<CpuClock>(CpuClock.NOT_AVAILABLE);
        SettingChangeListener cpuClockUpdater = (before, after) -> {
            if (after.booleanValue()) {
                cpuClock.set(CpuClock.CPU_CLOCK);
            } else {
                cpuClock.set(CpuClock.NOT_AVAILABLE);
            }
        };
        cpuClockUpdater.accept(null, (Object)((Boolean)config.get(GraphDatabaseSettings.track_query_cpu_time)));
        config.addListener(GraphDatabaseSettings.track_query_cpu_time, cpuClockUpdater);
        return cpuClock;
    }

    public StatementLifecycle create(StatementLifecycleTransactionInfo transactionInfo, String statement, MapValue params, ExecutingQuery.TransactionBinding transactionBinding) {
        ExecutingQuery executingQuery = this.executingQueryFactory.createUnbound(statement, params, transactionInfo.getClientConnectionInfo(), transactionInfo.getLoginContext().subject().executingUser(), transactionInfo.getLoginContext().subject().authenticatedUser(), transactionInfo.getTxMetadata());
        if (transactionBinding != null) {
            executingQuery.onTransactionBound(transactionBinding);
        }
        if (!this.shardQueryLogEnabled && transactionInfo.getSessionDatabaseReference().isShard()) {
            return new EmptyStatementLifecycle(executingQuery);
        }
        return new StatementLifecycleImpl(executingQuery);
    }

    private static class EmptyStatementLifecycle
    implements StatementLifecycle {
        private final ExecutingQuery executingQuery;

        private EmptyStatementLifecycle(ExecutingQuery executingQuery) {
            this.executingQuery = executingQuery;
        }

        @Override
        public void startProcessing() {
        }

        @Override
        public void donePreParsing(PreParsedQuery preParsedQuery) {
        }

        @Override
        public void doneFabricProcessing(FabricPlan plan, int preParserOffset) {
        }

        @Override
        public void doneRouterProcessing(ObfuscationMetadata obfuscateMetadata, InputPosition preParserOffset, boolean inCompositeContext, Set<InternalNotification> notifications) {
        }

        @Override
        public void startExecution(boolean shouldLogIfSingleQuery) {
        }

        @Override
        public void endSuccess() {
        }

        @Override
        public void endFailure(Throwable failure) {
        }

        @Override
        public ExecutingQuery getMonitoredQuery() {
            return this.executingQuery;
        }

        @Override
        public QueryExecutionMonitor getChildQueryMonitor() {
            return QueryExecutionMonitor.NO_OP;
        }
    }

    public class StatementLifecycleImpl
    implements StatementLifecycle {
        private final ExecutingQuery executingQuery;
        private QueryExecutionMonitor dbMonitor;
        private MonitoringMode monitoringMode;

        private StatementLifecycleImpl(ExecutingQuery executingQuery) {
            this.executingQuery = executingQuery;
        }

        @Override
        public void startProcessing() {
            this.getQueryExecutionMonitor().startProcessing(this.executingQuery);
        }

        @Override
        public void donePreParsing(PreParsedQuery preParsedQuery) {
            this.executingQuery.onPreparseReady(preParsedQuery.resolvedLanguage());
        }

        @Override
        public void doneFabricProcessing(FabricPlan plan, int preParserOffset) {
            this.executingQuery.onObfuscatorReady(CypherQueryObfuscator.apply((ObfuscationMetadata)plan.obfuscationMetadata()), preParserOffset);
            this.executingQuery.onFabricDeprecationNotificationsProviderReady((DeprecationNotificationsProvider)plan.deprecationNotificationsProvider());
            this.monitoringMode = plan.inCompositeContext() ? new ParentChildMonitoringMode() : new SingleQueryMonitoringMode();
        }

        @Override
        public void doneRouterProcessing(ObfuscationMetadata obfuscateMetadata, InputPosition preParserOffset, boolean inCompositeContext, Set<InternalNotification> notifications) {
            this.executingQuery.onObfuscatorReady(CypherQueryObfuscator.apply((ObfuscationMetadata)obfuscateMetadata), preParserOffset.offset());
            this.executingQuery.onFabricDeprecationNotificationsProviderReady((DeprecationNotificationsProvider)CypherDeprecationNotificationsProvider.fromJava((InputPosition)preParserOffset, notifications));
            this.monitoringMode = inCompositeContext ? new ParentChildMonitoringMode() : new SingleQueryMonitoringMode();
        }

        @Override
        public void startExecution(boolean shouldLogIfSingleQuery) {
            this.monitoringMode.startExecution(shouldLogIfSingleQuery);
        }

        @Override
        public void endSuccess() {
            QueryExecutionMonitor monitor = this.getQueryExecutionMonitor();
            monitor.beforeEnd(this.executingQuery, true);
            monitor.endSuccess(this.executingQuery);
        }

        @Override
        public void endFailure(Throwable failure) {
            QueryExecutionMonitor monitor = this.getQueryExecutionMonitor();
            Status status = failure instanceof Status.HasStatus ? ((Status.HasStatus)failure).status() : null;
            ErrorGqlStatusObject errorGqlStatusObject = failure instanceof ErrorGqlStatusObject ? (ErrorGqlStatusObject)failure : null;
            monitor.beforeEnd(this.executingQuery, false);
            monitor.endFailure(this.executingQuery, failure.getMessage(), status, errorGqlStatusObject);
        }

        private QueryExecutionMonitor getQueryExecutionMonitor() {
            return this.getDbMonitor().orElse(QueryStatementLifecycles.this.dbmsMonitor);
        }

        private Optional<QueryExecutionMonitor> getDbMonitor() {
            if (this.dbMonitor == null) {
                this.executingQuery.databaseId().flatMap(arg_0 -> QueryStatementLifecycles.this.databaseContextProvider.getDatabaseContext(arg_0)).map(dbm -> (Monitors)dbm.dependencies().resolveDependency(Monitors.class)).map(monitors -> (QueryExecutionMonitor)monitors.newMonitor(QueryExecutionMonitor.class, new String[0])).ifPresent(monitor -> {
                    this.dbMonitor = monitor;
                });
            }
            return Optional.ofNullable(this.dbMonitor);
        }

        @Override
        public ExecutingQuery getMonitoredQuery() {
            return this.executingQuery;
        }

        @Override
        public QueryExecutionMonitor getChildQueryMonitor() {
            return this.monitoringMode.getChildQueryMonitor();
        }

        boolean isParentChildMonitoringMode() {
            return this.monitoringMode.isParentChildMonitoringMode();
        }

        private class ParentChildMonitoringMode
        extends MonitoringMode {
            private ParentChildMonitoringMode() {
            }

            @Override
            boolean isParentChildMonitoringMode() {
                return true;
            }

            @Override
            void startExecution(Boolean shouldLogIfSingleQuery) {
                if (!shouldLogIfSingleQuery.booleanValue()) {
                    StatementLifecycleImpl.this.getQueryExecutionMonitor().startExecution(StatementLifecycleImpl.this.executingQuery);
                    StatementLifecycleImpl.this.executingQuery.onCompilationCompleted(null, null, null, 0);
                    StatementLifecycleImpl.this.executingQuery.onExecutionStarted(HeapHighWaterMarkTracker.NONE);
                }
            }

            @Override
            QueryExecutionMonitor getChildQueryMonitor() {
                return StatementLifecycleImpl.this.getQueryExecutionMonitor();
            }
        }

        private static abstract class MonitoringMode {
            private MonitoringMode() {
            }

            abstract boolean isParentChildMonitoringMode();

            abstract QueryExecutionMonitor getChildQueryMonitor();

            abstract void startExecution(Boolean var1);
        }

        private class SingleQueryMonitoringMode
        extends MonitoringMode {
            private SingleQueryMonitoringMode() {
            }

            @Override
            boolean isParentChildMonitoringMode() {
                return false;
            }

            @Override
            void startExecution(Boolean shouldLogIfSingleQuery) {
                if (shouldLogIfSingleQuery.booleanValue()) {
                    StatementLifecycleImpl.this.getQueryExecutionMonitor().startExecution(StatementLifecycleImpl.this.executingQuery);
                }
            }

            @Override
            QueryExecutionMonitor getChildQueryMonitor() {
                return QueryExecutionMonitor.NO_OP;
            }
        }
    }

    public static interface StatementLifecycle {
        public void startProcessing();

        public void donePreParsing(PreParsedQuery var1);

        public void doneFabricProcessing(FabricPlan var1, int var2);

        public void doneRouterProcessing(ObfuscationMetadata var1, InputPosition var2, boolean var3, Set<InternalNotification> var4);

        public void startExecution(boolean var1);

        public void endSuccess();

        public void endFailure(Throwable var1);

        public ExecutingQuery getMonitoredQuery();

        public QueryExecutionMonitor getChildQueryMonitor();
    }
}

