/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.QueryType;
import org.neo4j.graphdb.QueryExecutionType;

public class EffectiveQueryType {
    public static QueryExecutionType.QueryType effectiveQueryType(AccessMode requested, QueryType queryType) {
        if (queryType == QueryType.READ()) {
            return QueryExecutionType.QueryType.READ_ONLY;
        }
        if (queryType == QueryType.READ_PLUS_UNRESOLVED()) {
            return switch (requested) {
                default -> throw new MatchException(null, null);
                case AccessMode.READ -> QueryExecutionType.QueryType.READ_ONLY;
                case AccessMode.WRITE -> QueryExecutionType.QueryType.READ_WRITE;
            };
        }
        if (queryType == QueryType.WRITE()) {
            return QueryExecutionType.QueryType.READ_WRITE;
        }
        throw new IllegalArgumentException("Unexpected query type: " + String.valueOf(queryType));
    }

    public static AccessMode effectiveAccessMode(AccessMode requested, FabricPlan.ExecutionType executionType, QueryType queryType) {
        if (executionType == FabricPlan.EXPLAIN()) {
            return AccessMode.READ;
        }
        if (queryType == QueryType.READ()) {
            return AccessMode.READ;
        }
        if (queryType == QueryType.READ_PLUS_UNRESOLVED()) {
            return requested;
        }
        if (queryType == QueryType.WRITE()) {
            return AccessMode.WRITE;
        }
        throw new IllegalArgumentException("Unexpected query type: " + String.valueOf(queryType));
    }

    public static QueryExecutionType queryExecutionType(FabricPlan plan, AccessMode accessMode) {
        QueryExecutionType.QueryType effectiveQueryType = EffectiveQueryType.effectiveQueryType(accessMode, plan.queryType());
        if (plan.executionType() == FabricPlan.EXECUTE()) {
            return QueryExecutionType.query((QueryExecutionType.QueryType)effectiveQueryType);
        }
        if (plan.executionType() == FabricPlan.EXPLAIN()) {
            return QueryExecutionType.explained((QueryExecutionType.QueryType)effectiveQueryType);
        }
        if (plan.executionType() == FabricPlan.PROFILE()) {
            return QueryExecutionType.profiled((QueryExecutionType.QueryType)effectiveQueryType);
        }
        throw new IllegalArgumentException("Unexpected execution type: " + String.valueOf(plan.executionType()));
    }
}

