/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.Arrays;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class InvalidSpatialArgumentException
extends InvalidArgumentException {
    @Deprecated
    private InvalidSpatialArgumentException(String message) {
        super(message);
    }

    private InvalidSpatialArgumentException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidSpatialArgumentException invalidDimension(String crs, int dimension, double ... coordinate) {
        return new InvalidSpatialArgumentException(String.format("Cannot create point, CRS %s expects %d dimensions, but got coordinates %s", crs, dimension, Arrays.toString(coordinate)));
    }

    public static InvalidSpatialArgumentException infiniteCoordinateValue(double ... coordinate) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N24).withParam(GqlParams.StringParam.valueType, "point").withParam(GqlParams.StringParam.coordinates, Arrays.toString(coordinate)).build()).build();
        return new InvalidSpatialArgumentException(gql, "Cannot create a point with non-finite coordinate values: " + Arrays.toString(coordinate));
    }

    public static InvalidSpatialArgumentException invalidGeographicCoordinates(double ... coordinate) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N23).withParam(GqlParams.StringParam.coordinates, Arrays.toString(coordinate)).build()).build();
        return new InvalidSpatialArgumentException(gql, "Cannot create WGS84 point with invalid coordinate: " + Arrays.toString(coordinate) + ". Valid range for Y coordinate is [-90, 90].");
    }

    public static InvalidSpatialArgumentException invalidCoordinateSystem(int crs) {
        return InvalidSpatialArgumentException.invalidCoordinateSystem("code=" + crs);
    }

    public static InvalidSpatialArgumentException invalidCoordinateSystem(String crs) {
        return new InvalidSpatialArgumentException("Unknown coordinate reference system: " + crs);
    }
}

