/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class UpgradeException
extends Neo4jException {
    private UpgradeException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static UpgradeException conflictingDisplayNames(String db1, String db2) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N76).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N87).withParam(GqlParams.StringParam.db1, db1).withParam(GqlParams.StringParam.db2, db2).build()).build();
        String legacyMsg = String.format("The upgrade to a new Neo4j version failed. Databases '%s' and '%s' have ambiguous names. Rename one of them before retrying the upgrade.", db1, db2);
        return new UpgradeException(gql, legacyMsg);
    }

    public Status status() {
        return Status.Statement.ConstraintVerificationFailed;
    }
}

