/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.Arrays;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class InvalidCypherOption
extends InvalidArgumentException {
    private InvalidCypherOption(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidCypherOption invalidCombination(String optionName1, String option1, String optionName2, String option2) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N08).withParam(GqlParams.StringParam.option1, optionName1 + ": " + option1).withParam(GqlParams.StringParam.option2, optionName2 + ": " + option2).build()).build();
        return new InvalidCypherOption(gql, String.format("Cannot combine %s '%s' with %s '%s'", optionName1, option1, optionName2, option2));
    }

    public static InvalidCypherOption parallelRuntimeIsDisabled() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N44).build()).build();
        return new InvalidCypherOption(gql, "Parallel runtime has been disabled, please enable it or upgrade to a bigger Aura instance.");
    }

    public static InvalidCypherOption invalidOption(String input, String name, String ... validOptions) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N10).withParam(GqlParams.StringParam.input, input).withParam(GqlParams.StringParam.option, name).withParam(GqlParams.ListParam.optionList, Arrays.stream(validOptions).toList()).build()).build();
        return new InvalidCypherOption(gql, String.format("%s is not a valid option for %s. Valid options are: %s", input, name, String.join((CharSequence)", ", validOptions)));
    }

    public static InvalidCypherOption conflictingOptionForName(String name) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N09).withParam(GqlParams.StringParam.option, name).build()).build();
        return new InvalidCypherOption(gql, "Can't specify multiple conflicting values for " + name);
    }

    public static InvalidCypherOption unsupportedOptions(String ... keys) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N07).withParam(GqlParams.ListParam.optionList, Arrays.stream(keys).toList()).build()).build();
        return new InvalidCypherOption(gql, String.format("Unsupported options: %s", String.join((CharSequence)", ", keys)));
    }

    public static InvalidCypherOption sourceGenerationDisabled(String msgTitle) {
        String msg = "In order to use source generation you need to enable `internal.cypher.pipelined.allow_source_generation`";
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)msg);
        return new InvalidCypherOption(gql, msg);
    }
}

