/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexHintException
extends Neo4jException {
    private IndexHintException(ErrorGqlStatusObject gqlStatusObject, String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        super(gqlStatusObject, IndexHintException.msg(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public Status status() {
        return Status.Schema.IndexNotFound;
    }

    public static IndexHintException indexNotFound(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType, String formattedIndex) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N69).withParam(GqlParams.StringParam.idxDescrOrName, formattedIndex).build()).build();
        return new IndexHintException(gql, variableName, labelOrRelType, properties, entityType, indexType);
    }

    private static String msg(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        return String.format("No such index: %s", IndexHintException.indexFormatString(variableName, labelOrRelType, properties, entityType, indexType));
    }

    public static String indexFormatString(String variableName, String labelOrRelType, List<String> properties, EntityType entityType, IndexHintIndexType indexType) {
        String escapedVarName = IndexHintException.escape(variableName);
        String escapedLabelOrRelTypeName = IndexHintException.escape(labelOrRelType);
        String propertyNames = properties.stream().map(propertyName -> escapedVarName + "." + IndexHintException.escape(propertyName)).collect(Collectors.joining(", "));
        String typeString = switch (indexType.ordinal()) {
            case 1 -> "BTREE ";
            case 2 -> "TEXT ";
            case 3 -> "RANGE ";
            case 4 -> "POINT ";
            default -> "";
        };
        return switch (entityType) {
            default -> throw new MatchException(null, null);
            case EntityType.NODE -> String.format("%sINDEX FOR (%s:%s) ON (%s)", typeString, escapedVarName, escapedLabelOrRelTypeName, propertyNames);
            case EntityType.RELATIONSHIP -> String.format("%sINDEX FOR ()-[%s:%s]-() ON (%s)", typeString, escapedVarName, escapedLabelOrRelTypeName, propertyNames);
        };
    }

    private static String escape(String str) {
        return "`" + str.replace("`", "``") + "`";
    }

    public static enum IndexHintIndexType {
        ANY,
        BTREE,
        TEXT,
        RANGE,
        POINT;

    }
}

