/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class InvalidTemporalArgumentException
extends InvalidArgumentException {
    private InvalidTemporalArgumentException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidTemporalArgumentException namedTimeZoneWithoutDate() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22007).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N13).build()).build();
        return new InvalidTemporalArgumentException(gql, "Using a named time zone e.g. [UTC] is not valid for a time without a date. Instead, use a specific time zone string e.g. +00:00.");
    }

    public static InvalidTemporalArgumentException invalidOffset(String offset) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)offset);
        return new InvalidTemporalArgumentException(gql, "Not a valid offset: " + offset);
    }
}

