/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class InvalidSemanticsException
extends Neo4jException {
    private InvalidSemanticsException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    private InvalidSemanticsException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InvalidSemanticsException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new InvalidSemanticsException(gql, message);
    }

    public static InvalidArgumentException compositeUnsupportedInCommunity() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N27).withParam(GqlParams.StringParam.feat, "Composite database").withParam(GqlParams.StringParam.edition, "community edition").build();
        return new InvalidArgumentException(gql, "Composite database is not supported in Community Edition");
    }

    public static InvalidSemanticsException invalidCombinationOfProfileAndExplain() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N52).build()).build();
        return new InvalidSemanticsException(gql, "Can't mix PROFILE and EXPLAIN");
    }

    public static InvalidSemanticsException unsupportedAccessOfCompositeDatabase(String accessedGraph, String sessionGraph) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N04).withParam(GqlParams.StringParam.db1, accessedGraph).withParam(GqlParams.StringParam.db2, sessionGraph).withParam(GqlParams.StringParam.db3, accessedGraph).build()).build();
        String legacyMessage = "Accessing a composite database and its constituents is only allowed when connected to it. " + "Attempted to access '%s' while connected to '%s'".formatted(accessedGraph, sessionGraph);
        return new InvalidSemanticsException(gql, legacyMessage);
    }

    public static InvalidSemanticsException unsupportedRequestOnSystemDatabase(String invalidInput, String legacyMessage, boolean addSystemProcedureCause) {
        ErrorGqlStatusObject systemProcCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA9).build();
        ErrorGqlStatusObjectImplementation.Builder disallowedOnSystemCauseBase = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N17).withParam(GqlParams.StringParam.input, invalidInput);
        ErrorGqlStatusObjectImplementation.Builder disallowedOnSystemCause = addSystemProcedureCause ? disallowedOnSystemCauseBase.withCause(systemProcCause) : disallowedOnSystemCauseBase;
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(disallowedOnSystemCause.build()).build();
        return new InvalidSemanticsException(gql, legacyMessage);
    }

    public static InvalidSemanticsException invalidRegex(String errorMsg, String regex) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N11((String)regex);
        return new InvalidSemanticsException(gql, "Invalid Regex: " + errorMsg, null);
    }

    public static InvalidSemanticsException accessingMultipleGraphsOnlySupportedOnCompositeDatabases(String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA5).build()).build();
        return new InvalidSemanticsException(gql, legacyMessage);
    }

    public static InvalidSemanticsException cannotMergeNodeNullProperty(String key, String labelString) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N31();
        return new InvalidSemanticsException(gql, String.format("Cannot merge the following node because of null property value for '%s': (%s {%s: null})", key, labelString, key));
    }

    public static InvalidSemanticsException cannotMergeNodeNaNProperty(String key, String labelsString) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N31();
        return new InvalidSemanticsException(gql, String.format("Cannot merge the following node because of NaN property value for '%s': (%s {%s: NaN})", key, labelsString, key));
    }

    public static InvalidSemanticsException cannotMergeRelPropertyValue(String value, String key, String startVarPart, String stringifiedRelType, String endVarPart) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N31();
        return new InvalidSemanticsException(gql, String.format("Cannot merge the following relationship because of %s property value for '%s': (%s)-[:%s {%s: %s}]->(%s)", value, key, startVarPart, stringifiedRelType, key, value, endVarPart));
    }

    public static InvalidSemanticsException invalidShardTarget(String action, String db1, String db2) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N0A).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.StringParam.db1, db1).withParam(GqlParams.StringParam.db2, db2).build()).build();
        return new InvalidSemanticsException(gql, String.format("%s is not allowed with a shard target. Target the sharded database `%s` instead of `%s`.", action, db1, db2));
    }

    public static InvalidSemanticsException invalidShardedTarget(String db1, String db2) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N0B).withParam(GqlParams.StringParam.db1, db1).withParam(GqlParams.StringParam.db2, db2).build()).build();
        return new InvalidSemanticsException(gql, String.format("The database identified by `%s` is sharded. Drop the database `%s` before recreating.", db1, db2));
    }

    public static InvalidSemanticsException invalidAlterStandardTarget(String action) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N0C).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.StringParam.typeDescription, "standard database").build()).build();
        return new InvalidSemanticsException(gql, String.format("%s is not allowed with a standard database target", action));
    }

    public static InvalidSemanticsException invalidAlterShardedTarget(String action) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N0C).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.StringParam.typeDescription, "sharded database").build()).build();
        return new InvalidSemanticsException(gql, String.format("%s is not allowed with a sharded database target", action));
    }

    public static InvalidSemanticsException invalidAlterGraphShardTarget(String action) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N0C).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.StringParam.typeDescription, "graph shard").build()).build();
        return new InvalidSemanticsException(gql, String.format("%s is not allowed with a graph shard target", action));
    }

    public static InvalidSemanticsException invalidAlterShardTarget(String action) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N0C).withParam(GqlParams.StringParam.action, action).withParam(GqlParams.StringParam.typeDescription, "property shard").build()).build();
        return new InvalidSemanticsException(gql, String.format("%s is not allowed with a property shard target", action));
    }

    public static InvalidSemanticsException profileNotSupportedOnComposite() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N06).withParam(GqlParams.StringParam.action, "PROFILE").build()).build();
        return new InvalidSemanticsException(gql, "'PROFILE' is not supported on composite databases.");
    }

    public static InvalidSemanticsException routingNotSupportedInEmbedded() {
        return new InvalidSemanticsException(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_08N05).build(), "Query routing is not available in embedded sessions. Try running the query using a Neo4j driver or the HTTP API.");
    }

    public static InvalidSemanticsException expectedStaticGraphSelection() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N72).build()).build();
        return new InvalidSemanticsException(gql, "Expected static graph selection");
    }

    public static InvalidSemanticsException unsupportedAccessOfStandardDb(String graph, String composite) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N05).withParam(GqlParams.StringParam.db1, graph).withParam(GqlParams.StringParam.db2, composite).withParam(GqlParams.StringParam.db3, graph).build()).build();
        return new InvalidSemanticsException(gql, String.format("When connected to a composite database, access is allowed only to its constituents. Attempted to access '%s' while connected to '%s'", graph, composite));
    }

    public static InvalidSemanticsException missingTransactionId() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N06).withParam(GqlParams.ListParam.inputList, List.of("transaction id")).build();
        return new InvalidSemanticsException(gql, "Missing transaction id to terminate, the transaction id can be found using `SHOW TRANSACTIONS`.");
    }

    public Status status() {
        return Status.Statement.SemanticError;
    }
}

