/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class InternalException
extends Neo4jException {
    @Deprecated
    public InternalException(String message, Throwable cause) {
        super(message, cause);
    }

    private InternalException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    @Deprecated
    public InternalException(String message) {
        super(message);
    }

    protected InternalException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public static InternalException internalError(String msgTitle, String message) {
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)msgTitle, (String)message);
        return new InternalException(gql, message);
    }

    public static InternalException foundNoSolutionForBlock(int blockSize, String blockCandidates, String table) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N24).build();
        return new InternalException(gql, String.format("Found no solution for block with size %d,\n|%s were the selected candidates from the table %s", blockSize, blockCandidates, table));
    }

    public static InternalException foundNoPlanWithinConstraints(String setting1, String setting2) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N24).build();
        return new InternalException(gql, String.format("Unfortunately, the planner was unable to find a plan within the constraints provided.\n|Try increasing the config values `%s`\n|and `%s` to allow\n|for a larger sub-plan table and longer planning time.", setting1, setting2));
    }

    public static InternalException expectedNode(String value, String name) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)value, (String)name, List.of("NODE"));
        return new InternalException(gql, String.format("Expected variable `%s` to be a node, got %s", name, value));
    }

    public static InternalException expectedNodeFoundInsteadValue(String value, String name) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)value, (String)name, List.of("NODE"));
        return new InternalException(gql, String.format("Expected to find a node at '%s' but found instead: %s", name, value));
    }

    public static InternalException expectedNodeFoundValueInstead(String value, String name) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N27((String)value, (String)name, List.of("NODE"));
        return new InternalException(gql, String.format("Expected to find a node at '%s' but found %s instead", name, value));
    }

    public Status status() {
        return Status.Statement.ExecutionFailed;
    }
}

