/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.diagnostics;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class DiagnosticsManager {
    private static final int CAPTION_WIDTH = 80;
    private static final String NAME_START = "[ ";
    private static final String NAME_END = " ]";
    private final Log log;

    public DiagnosticsManager(Log log) {
        this.log = log;
    }

    public void dump(DiagnosticsProvider provider) {
        this.dump(provider, this.log);
    }

    public void dump(List<DiagnosticsProvider> providers, Log dumpLog) {
        dumpLog.bulk(bulkLog -> {
            for (DiagnosticsProvider provider : providers) {
                this.dump(provider, (Log)bulkLog);
            }
        });
    }

    public <E extends Enum> void dump(Class<E> enumProvider) {
        this.dump(enumProvider, this.log);
    }

    public <E extends Enum> void dump(Class<E> enumProvider, Log log) {
        for (Enum provider : (Enum[])enumProvider.getEnumConstants()) {
            this.dump((DiagnosticsProvider)((Object)provider), log);
        }
    }

    public void dump(DiagnosticsProvider provider, Log log) {
        if (log == NullLog.getInstance()) {
            return;
        }
        try {
            DiagnosticsManager.header(log, provider.getDiagnosticsName());
            provider.dump(log.infoLogger());
            log.info("");
        }
        catch (Exception cause) {
            log.error("Failure while logging diagnostics for " + provider, (Throwable)cause);
        }
    }

    public void section(Log log, String sectionName) {
        log.info("*".repeat(80));
        log.info(StringUtils.center((String)DiagnosticsManager.title(sectionName), (int)80));
        log.info("*".repeat(80));
    }

    private static void header(Log log, String caption) {
        log.info("-".repeat(80));
        log.info(StringUtils.center((String)DiagnosticsManager.title(caption), (int)80));
        log.info("-".repeat(80));
    }

    private static String title(String name) {
        return NAME_START + name + NAME_END;
    }
}

