/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.neo4j.dbms.diagnostics.profile.Profiler;
import org.neo4j.internal.helpers.Exceptions;

class ProfileTool
implements AutoCloseable {
    private final List<Profiler> profilers = new ArrayList<Profiler>();
    private boolean running;

    ProfileTool() {
    }

    boolean add(Profiler profiler) {
        return profiler.available() && this.profilers.add(profiler);
    }

    synchronized void start() {
        if (!this.running) {
            this.running = true;
            this.safeProfilerOperation(Profiler::startProfiling);
        }
    }

    synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.safeProfilerOperation(Profiler::stopProfiling);
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    boolean hasRunningProfilers() {
        return this.running && this.profilers.stream().anyMatch(profiler -> profiler.failure() == null);
    }

    Iterable<Profiler> profilers() {
        return this.profilers;
    }

    private void safeProfilerOperation(Consumer<Profiler> profilerOperation) {
        RuntimeException exception = null;
        for (Profiler profiler : this.profilers) {
            try {
                profilerOperation.accept(profiler);
            }
            catch (RuntimeException e) {
                exception = (RuntimeException)Exceptions.chain(exception, (Throwable)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

