/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.storageengine.StoreFileClosedException;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.api.TransactionIdStore;

public class DetailedDbInfoProvider {
    private final DatabaseContextProvider<?> databaseContextProvider;

    public DetailedDbInfoProvider(DatabaseContextProvider<?> databaseContextProvider) {
        this.databaseContextProvider = databaseContextProvider;
    }

    public long lastCommittedTxId(DatabaseId databaseId) {
        return this.databaseContextProvider.getDatabaseContext(databaseId).filter(databaseContext -> databaseContext.database().isStarted()).map(DatabaseContext::dependencies).map(dependencies -> (TransactionIdStore)dependencies.resolveDependency(TransactionIdStore.class)).flatMap(transactionIdStore -> {
            try {
                return Optional.of(transactionIdStore.getLastCommittedTransactionId());
            }
            catch (StoreFileClosedException e) {
                return Optional.empty();
            }
        }).orElse(-1L);
    }

    public StoreId storeId(DatabaseId databaseId) {
        return this.databaseContextProvider.getDatabaseContext(databaseId).filter(databaseContext -> databaseContext.database().isStarted()).flatMap(databaseContext -> {
            try {
                return Optional.of(databaseContext.database().getStoreId());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }).orElse(StoreId.UNKNOWN);
    }

    public ExternalStoreId externalStoreId(DatabaseId databaseId) {
        return this.databaseContextProvider.getDatabaseContext(databaseId).filter(databaseContext -> databaseContext.database().isStarted()).map(DatabaseContext::dependencies).map(dependencies -> (StoreIdProvider)dependencies.resolveDependency(StoreIdProvider.class)).flatMap(storeIdProvider -> {
            try {
                return Optional.of(storeIdProvider.getExternalStoreId());
            }
            catch (StoreFileClosedException e) {
                return Optional.empty();
            }
        }).orElse(null);
    }
}

