/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.FileLockException;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.recovery.LogTailExtractor;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.ReadOnlyTransactionIdStore;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import picocli.CommandLine;

@CommandLine.Command(name="info", header={"Print information about a Neo4j database store."}, description={"Print information about a Neo4j database store, such as what version of Neo4j created it."})
public class StoreInfoCommand
extends AbstractAdminCommand {
    private static final String PLAIN_FORMAT = "text";
    private static final String JSON_FORMAT = "json";
    @CommandLine.Parameters(arity="0..1", paramLabel="<database>", defaultValue="*", description={"Name of the database to show info for. Can contain * and ? for globbing. Note that * and ? have special meaning in some shells and might need to be escaped or used with quotes."}, converter={Converters.DatabaseNamePatternConverter.class})
    private DatabaseNamePattern database;
    @CommandLine.Option(names={"--format"}, arity="1", defaultValue="text", description={"The format of the returned information."}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS, paramLabel="text|json", converter={FormatConverter.class})
    private boolean structuredFormat;
    @CommandLine.Option(names={"--from-path"}, description={"Path to databases directory."})
    private Path path;
    private final StorageEngineFactory.Selector storageEngineSelector;

    public StoreInfoCommand(ExecutionContext ctx) {
        this(ctx, StorageEngineFactory.SELECTOR);
    }

    StoreInfoCommand(ExecutionContext ctx, StorageEngineFactory.Selector storageEngineSelector) {
        super(ctx);
        this.storageEngineSelector = storageEngineSelector;
    }

    public void execute() {
        Config config = this.createConfig();
        Neo4jLayout neo4jLayout = Neo4jLayout.of((Configuration)config);
        try (FileSystemAbstraction fs = this.ctx.fs();
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler, (PageCacheTracer)PageCacheTracer.NULL);){
            this.validateDatabasesPath(fs, neo4jLayout.databasesDirectory());
            if (this.database.containsPattern()) {
                Collector<CharSequence, ?, String> collector = this.structuredFormat ? Collectors.joining(",", "[", "]") : Collectors.joining(System.lineSeparator() + System.lineSeparator());
                String result = Arrays.stream(fs.listFiles(this.path)).sorted(Comparator.comparing(Path::getFileName)).map(dbPath -> neo4jLayout.databaseLayout(dbPath.getFileName().toString())).filter(dbLayout -> this.database.matches(dbLayout.getDatabaseName()) && Validators.isExistingDatabase((StorageEngineFactory.Selector)this.storageEngineSelector, (FileSystemAbstraction)fs, (DatabaseLayout)dbLayout)).map(dbLayout -> this.printInfo(fs, (DatabaseLayout)dbLayout, pageCache, config, this.structuredFormat, true)).collect(collector);
                this.ctx.out().println(result);
            } else {
                DatabaseLayout databaseLayout = neo4jLayout.databaseLayout(this.database.getDatabaseName());
                if (!Validators.isExistingDatabase((StorageEngineFactory.Selector)this.storageEngineSelector, (FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout)) {
                    throw new CommandFailedException(String.format("Database does not exist: '%s'. Directory '%s' does not contain a database", this.database.getDatabaseName(), databaseLayout.databaseDirectory()));
                }
                this.ctx.out().println(this.printInfo(fs, databaseLayout, pageCache, config, this.structuredFormat, false));
            }
        }
        catch (CommandFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandFailedException(String.format("Failed to execute command: '%s'.", e.getMessage()), (Throwable)e);
        }
    }

    private Config createConfig() {
        Config.Builder builder = this.createPrefilledConfigBuilder().set(GraphDatabaseSettings.read_only_database_default, (Object)true);
        if (this.path != null) {
            builder.set(GraphDatabaseInternalSettings.databases_root_path, (Object)this.path.toAbsolutePath().normalize());
        }
        return builder.build();
    }

    private void validateDatabasesPath(FileSystemAbstraction fs, Path databasesPath) {
        if (!fs.isDirectory(databasesPath)) {
            throw new IllegalArgumentException(String.format("Provided path %s must point to a directory.", databasesPath));
        }
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)databasesPath);
        if (Validators.isExistingDatabase((StorageEngineFactory.Selector)this.storageEngineSelector, (FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout)) {
            throw new IllegalArgumentException(String.format("The directory %s contains the store files of a single database. --from-path should point to the databases directory.", databasesPath));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String printInfo(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, Config config, boolean structured, boolean failSilently) {
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        try (Closeable ignored = LockChecker.checkDatabaseLock(databaseLayout);){
            String string;
            block18: {
                CursorContext cursorContext = CursorContextFactory.NULL_CONTEXT_FACTORY.create("printInfo");
                try {
                    StorageEngineFactory storageEngineFactory = (StorageEngineFactory)this.storageEngineSelector.selectStorageEngine(fs, databaseLayout).orElseThrow();
                    StoreId storeId = storageEngineFactory.retrieveStoreId(fs, databaseLayout, pageCache, cursorContext);
                    if (storeId == null) {
                        throw new CommandFailedException(String.format("Could not find version metadata in store '%s'", databaseLayout.databaseDirectory()));
                    }
                    StoreVersion versionInformation = (StoreVersion)storageEngineFactory.versionInformation((StoreVersionIdentifier)storeId).orElseThrow();
                    LogTailMetadata logTail = this.getLogTail(fs, databaseLayout, pageCache, config, (MemoryTracker)memoryTracker, storageEngineFactory);
                    boolean recoveryRequired = StoreInfoCommand.checkRecoveryState(fs, pageCache, databaseLayout, config, (MemoryTracker)memoryTracker, storageEngineFactory);
                    ReadOnlyTransactionIdStore txIdStore = new ReadOnlyTransactionIdStore(logTail);
                    long lastTxId = txIdStore.getLastCommittedTransactionId();
                    StoreVersion successorVersion = versionInformation.successorStoreVersion().orElse(null);
                    StoreInfo storeInfo = StoreInfo.notInUseResult(databaseLayout.getDatabaseName(), versionInformation, successorVersion, lastTxId, recoveryRequired);
                    string = storeInfo.print(structured);
                    if (cursorContext == null) break block18;
                }
                catch (Throwable throwable) {
                    if (cursorContext != null) {
                        try {
                            cursorContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cursorContext.close();
            }
            return string;
        }
        catch (FileLockException e) {
            if (!failSilently) {
                throw new CommandFailedException(String.format("Failed to execute command as the database '%s' is in use. Please stop it and try again.", databaseLayout.getDatabaseName()), (Throwable)e);
            }
            return StoreInfo.inUseResult(databaseLayout.getDatabaseName()).print(structured);
        }
        catch (CommandFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandFailedException(String.format("Failed to execute command: '%s'.", e.getMessage()), (Throwable)e);
        }
    }

    private LogTailMetadata getLogTail(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, Config config, MemoryTracker memoryTracker, StorageEngineFactory storageEngineFactory) throws IOException {
        LogTailExtractor logTailExtractor = new LogTailExtractor(fs, pageCache, config, storageEngineFactory, DatabaseTracers.EMPTY);
        return logTailExtractor.getTailMetadata(databaseLayout, memoryTracker);
    }

    private static boolean checkRecoveryState(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout databaseLayout, Config config, MemoryTracker memoryTracker, StorageEngineFactory storageEngineFactory) {
        try {
            return Recovery.isRecoveryRequired((FileSystemAbstraction)fs, (PageCache)pageCache, (DatabaseLayout)databaseLayout, (StorageEngineFactory)storageEngineFactory, (Config)config, Optional.empty(), (MemoryTracker)memoryTracker, (DatabaseTracers)DatabaseTracers.EMPTY);
        }
        catch (Exception e) {
            throw new CommandFailedException(String.format("Failed to execute command when checking for recovery state: '%s'.", e.getMessage()), (Throwable)e);
        }
    }

    private record StoreInfo(String databaseName, StoreVersion currentStoreVersion, StoreVersion successorStoreVersion, long lastCommittedTransaction, boolean recoveryRequired, boolean inUse) {
        static StoreInfo inUseResult(String databaseName) {
            return new StoreInfo(databaseName, null, null, -1L, true, true);
        }

        static StoreInfo notInUseResult(String databaseName, StoreVersion currentStoreVersion, StoreVersion successorStoreVersion, long lastCommittedTransaction, boolean recoveryRequired) {
            return new StoreInfo(databaseName, currentStoreVersion, successorStoreVersion, lastCommittedTransaction, recoveryRequired, false);
        }

        List<StoreInfoField> printFields() {
            return List.of(new StoreInfoField(InfoType.DatabaseName, this.databaseName), new StoreInfoField(InfoType.InUse, Boolean.toString(this.inUse)), new StoreInfoField(InfoType.StoreFormat, this.currentStoreVersion != null ? this.currentStoreVersion.getStoreVersionUserString() : null), new StoreInfoField(InfoType.StoreFormatIntroduced, this.currentStoreVersion != null ? this.currentStoreVersion.introductionNeo4jVersion() : null), new StoreInfoField(InfoType.StoreFormatSuperseded, this.successorStoreVersion != null ? this.successorStoreVersion.introductionNeo4jVersion() : null), new StoreInfoField(InfoType.LastCommittedTransaction, Long.toString(this.lastCommittedTransaction)), new StoreInfoField(InfoType.RecoveryRequired, Boolean.toString(this.recoveryRequired)));
        }

        String print(boolean structured) {
            if (!structured) {
                return this.printFields().stream().filter(p -> Objects.nonNull(p.value())).map(p -> p.type().justifiedPretty(p.value())).collect(Collectors.joining(System.lineSeparator()));
            }
            return this.printFields().stream().map(p -> p.type().structuredJson(p.value())).collect(Collectors.joining(",", "{", "}"));
        }

        private record StoreInfoField(InfoType type, String value) {
        }
    }

    private static enum InfoType {
        InUse("Database in use", "inUse"),
        DatabaseName("Database name", "databaseName"),
        StoreFormat("Store format version", "storeFormat"),
        StoreFormatIntroduced("Store format introduced in", "storeFormatIntroduced"),
        StoreFormatSuperseded("Store format superseded in", "storeFormatSuperseded"),
        LastCommittedTransaction("Last committed transaction id", "lastCommittedTransaction"),
        RecoveryRequired("Store needs recovery", "recoveryRequired");

        private final String prettyPrint;
        private final String jsonKey;

        private InfoType(String prettyPrint, String jsonKey) {
            this.prettyPrint = prettyPrint;
            this.jsonKey = jsonKey;
        }

        String justifiedPretty(String value) {
            String nullSafeValue = value == null ? "N/A" : value;
            String leftJustifiedFmt = "%-30s%s";
            return String.format(leftJustifiedFmt, this.prettyPrint + ":", nullSafeValue);
        }

        String structuredJson(String value) {
            String kFmt = "\"%s\":";
            String kvFmt = kFmt + "\"%s\"";
            return value == null ? String.format(kFmt + "null", this.jsonKey) : String.format(kvFmt, this.jsonKey, value);
        }
    }

    static class FormatConverter
    implements CommandLine.ITypeConverter<Boolean> {
        FormatConverter() {
        }

        public Boolean convert(String name) {
            String lowerCase;
            return switch (lowerCase = name.toLowerCase(Locale.ROOT)) {
                case StoreInfoCommand.PLAIN_FORMAT, "false" -> false;
                case StoreInfoCommand.JSON_FORMAT, "true" -> true;
                default -> throw new CommandLine.TypeConversionException(String.format("Invalid format '%s'. Supported options are 'text' or 'json'", name));
            };
        }
    }
}

