/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.commandline.dbms.LoggingSettingsMigrator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingMigrator;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;
import org.neo4j.service.Services;

public class ConfigFileMigrator {
    private static final String COMMENT_LINE_SEPARATOR = "\n";
    private final PrintStream out;
    private final PrintStream err;
    private final ClassLoader classLoader;
    private final Set<SettingMigrator> migrators;
    private final Set<String> knownSettings;

    public ConfigFileMigrator(PrintStream out, PrintStream err, ClassLoader classLoader) {
        this.out = out;
        this.err = err;
        this.classLoader = classLoader;
        this.migrators = ConfigFileMigrator.getSortedMigrators(classLoader);
        this.knownSettings = this.getKnownSettings();
    }

    private static Set<SettingMigrator> getSortedMigrators(ClassLoader classLoader) {
        TreeSet<SettingMigrator> migrators = new TreeSet<SettingMigrator>(Comparator.comparing(o -> o.getClass().getName()));
        migrators.addAll(Services.loadAll((ClassLoader)classLoader, SettingMigrator.class));
        return migrators;
    }

    public void migrate(Path sourceConfigFile, Path destinationConfigFile) throws IOException {
        try {
            PropertiesConfiguration config = this.readIntoConfig(sourceConfigFile);
            LoggingSettingsMigrator loggingSettingsMigrator = new LoggingSettingsMigrator(sourceConfigFile, this.out, destinationConfigFile);
            loggingSettingsMigrator.migrate();
            this.migrateSettings(config);
            this.writeToFile(config, destinationConfigFile);
            this.validate(destinationConfigFile);
        }
        catch (ConfigurationException e) {
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private void migrateSettings(PropertiesConfiguration config) {
        PropertiesConfigurationLayout layout = config.getLayout();
        StringBuilder comment = new StringBuilder();
        int leadingEmptyLines = 0;
        ArrayList originalKeysInOrder = new ArrayList(layout.getKeys());
        for (String originalKey : originalKeysInOrder) {
            List<String> originalValues = config.getList(String.class, originalKey);
            if (originalValues.isEmpty()) {
                originalValues = List.of("");
            }
            String originalComment = layout.getComment(originalKey);
            int originalFreeLines = layout.getBlancLinesBefore(originalKey);
            config.clearProperty(originalKey);
            if (!comment.isEmpty()) {
                comment.append(StringUtils.join((Object[])new String[]{COMMENT_LINE_SEPARATOR.repeat(originalFreeLines)}));
            } else {
                leadingEmptyLines = originalFreeLines;
            }
            if (StringUtils.isNotEmpty((CharSequence)originalComment)) {
                if (!comment.isEmpty()) {
                    comment.append(COMMENT_LINE_SEPARATOR);
                }
                comment.append(originalComment);
            }
            List<MigratedSetting> maybeMigratedSettings = this.migrate(originalKey, originalValues, removedOriginalValue -> {
                this.appendCommentedOutSetting(comment, originalKey, (String)removedOriginalValue, "REMOVED");
                this.out.printf("%s=%s REMOVED%n", originalKey, removedOriginalValue);
            }, unrecognisedOriginalValue -> {
                this.appendCommentedOutSetting(comment, originalKey, (String)unrecognisedOriginalValue, "UNKNOWN");
                this.err.printf("%s=%s REMOVED UNKNOWN%n", originalKey, unrecognisedOriginalValue);
            });
            for (MigratedSetting migratedSetting : maybeMigratedSettings) {
                List<String> values = migratedSetting.values;
                String key = migratedSetting.key;
                if (values.size() > 1 && !Config.Builder.allowedMultipleDeclarations((String)key)) {
                    for (int i = 0; i < values.size() - 1; ++i) {
                        this.appendCommentedOutSetting(comment, key, values.get(i), "DUPLICATE");
                        this.err.printf("%s=%s REMOVED DUPLICATE%n", key, values.get(i));
                    }
                    values = List.of(values.get(values.size() - 1));
                }
                config.setProperty(key, values);
                for (String value : values) {
                    boolean unchanged;
                    String originalValue = migratedSetting.originalValues.get(value);
                    boolean bl = unchanged = values.size() == 1 && Objects.equals(originalKey, key) && Objects.equals(originalValue, value);
                    if (unchanged) {
                        this.out.printf("%s=%s UNCHANGED%n", originalKey, originalValue);
                        continue;
                    }
                    this.out.printf("%s=%s MIGRATED -> %s=%s%n", originalKey, originalValue, key, value);
                }
                layout.setBlancLinesBefore(key, leadingEmptyLines);
                layout.setComment(key, (String)StringUtils.defaultIfBlank((CharSequence)comment.toString(), null));
                comment.setLength(0);
                leadingEmptyLines = 0;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            layout.setFooterComment(StringUtils.join((Object[])new Serializable[]{COMMENT_LINE_SEPARATOR.repeat(leadingEmptyLines), comment, layout.getFooterComment()}));
        }
    }

    private void appendCommentedOutSetting(StringBuilder commentBuilder, String key, String value, String reason) {
        commentBuilder.append(COMMENT_LINE_SEPARATOR).append(String.format("%s=%s %s SETTING", key, value, reason));
    }

    private List<MigratedSetting> migrate(String originalKey, List<String> originalValues, Consumer<String> removedValueConsumer, Consumer<String> unrecognisedValueConsumer) {
        HashSet<String> migratedKeys = new HashSet<String>();
        HashMap<String, List> migratedValues = new HashMap<String, List>(originalValues.size());
        HashMap<String, Map> originalValueMapping = new HashMap<String, Map>(originalValues.size());
        for (String originalValue : originalValues) {
            MutableMap map = Maps.mutable.of((Object)originalKey, (Object)originalValue);
            this.migrators.forEach(arg_0 -> ConfigFileMigrator.lambda$migrate$3((Map)map, arg_0));
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (this.isSettingValid((String)entry.getKey(), (String)entry.getValue())) {
                        String migratedKey = (String)entry.getKey();
                        migratedKeys.add(migratedKey);
                        migratedValues.computeIfAbsent(migratedKey, ignored -> new ArrayList(originalValues.size())).add((String)entry.getValue());
                        originalValueMapping.computeIfAbsent(migratedKey, ignored -> new HashMap(originalValues.size())).put((String)entry.getValue(), originalValue);
                        continue;
                    }
                    unrecognisedValueConsumer.accept(originalValue);
                }
                continue;
            }
            removedValueConsumer.accept(originalValue);
        }
        return migratedKeys.stream().map(key -> new MigratedSetting((String)key, (List)migratedValues.get(key), (Map)originalValueMapping.get(key))).sorted(Comparator.comparing(MigratedSetting::key)).toList();
    }

    private boolean isSettingValid(String key, String value) {
        if (!this.knownSettings.contains(key)) {
            try {
                this.configBuilder().setRaw(Map.of(key, value)).set(GraphDatabaseSettings.strict_config_validation, (Object)true).build();
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return true;
    }

    private void validate(Path config) {
        try {
            this.configBuilder().fromFile(config).set(GraphDatabaseSettings.strict_config_validation, (Object)true).build();
        }
        catch (RuntimeException e) {
            throw new CommandFailedException("Migrated file failed validation", (Throwable)e);
        }
    }

    private Config.Builder configBuilder() {
        return Config.newBuilder((ClassLoader)this.classLoader);
    }

    private void writeToFile(PropertiesConfiguration config, Path configFile) throws ConfigurationException, IOException {
        StringWriter sw = new StringWriter();
        PropertiesConfigurationLayout layout = config.getLayout();
        layout.setGlobalSeparator("=");
        layout.save(config, (Writer)sw);
        if (Files.exists(configFile, new LinkOption[0])) {
            Path preservedFilePath = configFile.getParent().resolve(configFile.getFileName() + ".old");
            this.out.println("Keeping original configuration file at: " + preservedFilePath);
            Files.move(configFile, preservedFilePath, new CopyOption[0]);
        }
        Files.writeString(configFile, (CharSequence)sw.toString(), new OpenOption[0]);
    }

    private PropertiesConfiguration readIntoConfig(Path configFile) throws IOException, ConfigurationException {
        try (InputStream stream = Files.newInputStream(configFile, new OpenOption[0]);){
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.getLayout().load(config, (Reader)new InputStreamReader(stream));
            PropertiesConfiguration propertiesConfiguration = config;
            return propertiesConfiguration;
        }
    }

    private Set<String> getKnownSettings() {
        return this.configBuilder().build().getDeclaredSettings().keySet();
    }

    private static /* synthetic */ void lambda$migrate$3(Map map, SettingMigrator m) {
        m.migrate(map, Map.of(), (InternalLog)NullLog.getInstance());
    }

    private record MigratedSetting(String key, List<String> values, Map<String, String> originalValues) {
    }
}

