/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.DetailedDatabaseInfo;
import org.neo4j.dbms.database.ExtendedDatabaseInfo;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.storageengine.api.StoreId;

public class DatabaseInfo {
    public static final String ROLE_PRIMARY = "primary";
    public static final String ROLE_SECONDARY = "secondary";
    public static final String ROLE_UNKNOWN = "unknown";
    public static final String STATUS_UNKNOWN = "unknown";
    public static final String STATUS_UNKNOWN_MESSAGE = "Server is unavailable";
    final NamedDatabaseId namedDatabaseId;
    final ServerId serverId;
    final TopologyGraphDbmsModel.DatabaseAccess access;
    final SocketAddress boltAddress;
    final SocketAddress catchupAddress;
    final String role;
    final boolean writer;
    final String status;
    final String statusMessage;

    public DatabaseInfo(NamedDatabaseId namedDatabaseId, ServerId serverId, TopologyGraphDbmsModel.DatabaseAccess access, SocketAddress boltAddress, SocketAddress catchupAddress, String role, boolean writer, String status, String statusMessage) {
        this.namedDatabaseId = namedDatabaseId;
        this.serverId = serverId;
        this.access = access;
        this.boltAddress = boltAddress;
        this.catchupAddress = catchupAddress;
        this.role = role;
        this.writer = writer;
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public DatabaseInfo(NamedDatabaseId namedDatabaseId, ServerId serverId, TopologyGraphDbmsModel.DatabaseAccess access, String role) {
        this(namedDatabaseId, serverId, access, null, null, role, false, "unknown", STATUS_UNKNOWN_MESSAGE);
    }

    public ExtendedDatabaseInfo extendWith(DetailedDatabaseInfo detailedDatabaseInfo) {
        return this.extendWith(detailedDatabaseInfo, detailedDatabaseInfo.lastCommittedTxId(), 1, 0);
    }

    public ExtendedDatabaseInfo extendWith(DetailedDatabaseInfo detailedDatabaseInfo, long maxCommittedTxId, int primariesCount, int secondariesCount) {
        long lastCommittedTxId = detailedDatabaseInfo.lastCommittedTxId();
        StoreId storeId = detailedDatabaseInfo.storeId();
        return new ExtendedDatabaseInfo(this.namedDatabaseId, this.serverId, this.access, this.boltAddress, this.catchupAddress, this.role, this.writer, this.status, this.statusMessage, lastCommittedTxId, lastCommittedTxId - maxCommittedTxId, storeId, primariesCount, secondariesCount, detailedDatabaseInfo.externalStoreId());
    }

    public NamedDatabaseId namedDatabaseId() {
        return this.namedDatabaseId;
    }

    public Optional<ServerId> serverId() {
        return Optional.ofNullable(this.serverId);
    }

    public ServerId rawServerId() {
        return this.serverId;
    }

    public TopologyGraphDbmsModel.DatabaseAccess access() {
        return this.access;
    }

    public Optional<SocketAddress> boltAddress() {
        return Optional.ofNullable(this.boltAddress);
    }

    public Optional<SocketAddress> catchupAddress() {
        return Optional.ofNullable(this.catchupAddress);
    }

    public String role() {
        return this.role;
    }

    public DatabaseInfo updateRole(String role) {
        return new DatabaseInfo(this.namedDatabaseId, this.serverId, this.access, this.boltAddress, this.catchupAddress, role, this.writer, this.status, this.statusMessage);
    }

    public boolean writer() {
        return this.writer;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseInfo that = (DatabaseInfo)o;
        return this.writer == that.writer && Objects.equals(this.namedDatabaseId, that.namedDatabaseId) && Objects.equals(this.serverId, that.serverId) && this.access == that.access && Objects.equals(this.boltAddress, that.boltAddress) && Objects.equals(this.catchupAddress, that.catchupAddress) && Objects.equals(this.role, that.role) && Objects.equals(this.status, that.status) && Objects.equals(this.statusMessage, that.statusMessage);
    }

    public int hashCode() {
        return Objects.hash(this.namedDatabaseId, this.serverId, this.access, this.boltAddress, this.catchupAddress, this.role, this.writer, this.status, this.statusMessage);
    }

    public String toString() {
        return "DatabaseInfo{namedDatabaseId=" + this.namedDatabaseId + ", serverId=" + this.serverId + ", access=" + this.access + ", boltAddress=" + this.boltAddress + ", catchupAddress=" + this.catchupAddress + ", role='" + this.role + "', writer=" + this.writer + ", status='" + this.status + "', statusMessage='" + this.statusMessage + "'}";
    }
}

