/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.List;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.routing.RichRoutingServerAddress;
import org.neo4j.dbms.routing.RoutingResult;

public class RichRoutingResult
extends RoutingResult {
    private final List<RichRoutingServerAddress> routeServerAddresses;
    private final List<RichRoutingServerAddress> writeServerAddresses;
    private final List<RichRoutingServerAddress> readServerAddresses;

    public RichRoutingResult(List<RichRoutingServerAddress> routeServerAddresses, List<RichRoutingServerAddress> writeServerAddresses, List<RichRoutingServerAddress> readServerAddresses, long timeToLiveMillis) {
        super(RichRoutingResult.externalBoltAddresses(routeServerAddresses), RichRoutingResult.externalBoltAddresses(writeServerAddresses), RichRoutingResult.externalBoltAddresses(readServerAddresses), timeToLiveMillis);
        this.routeServerAddresses = routeServerAddresses;
        this.writeServerAddresses = writeServerAddresses;
        this.readServerAddresses = readServerAddresses;
    }

    public List<RichRoutingServerAddress> routeServerAddresses() {
        return this.routeServerAddresses;
    }

    public List<RichRoutingServerAddress> writeServerAddresses() {
        return this.writeServerAddresses;
    }

    public List<RichRoutingServerAddress> readServerAddresses() {
        return this.readServerAddresses;
    }

    private static List<SocketAddress> externalBoltAddresses(List<RichRoutingServerAddress> serverAddresses) {
        return serverAddresses.stream().flatMap(sa -> sa.externalBoltAddress().stream()).toList();
    }
}

