/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.time.Duration;
import java.util.Objects;
import org.neo4j.dbms.archive.ArchiveProgressPrinter;
import org.neo4j.dbms.archive.printer.OutputProgressPrinter;
import org.neo4j.dbms.archive.printer.ProgressPrinters;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.ByteUnit;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.util.VisibleForTesting;

class LoggingArchiveProgressPrinter
implements ArchiveProgressPrinter {
    private static final long PRINT_INTERVAL = Duration.ofSeconds(60L).toMillis();
    private final OutputProgressPrinter progressPrinter;
    private long currentBytes;
    private long currentFiles;
    private boolean done;
    private long maxBytes;
    private long maxFiles;
    private long startTime;
    private double printingTime;
    private final SystemNanoClock clock;
    private boolean force;
    private Deadline deadline = null;
    private PercentageCondition percentage = null;

    public static ArchiveProgressPrinter createProgressPrinter(OutputProgressPrinter progressPrinter) {
        Objects.requireNonNull(progressPrinter);
        if (progressPrinter instanceof ProgressPrinters.EmptyOutputProgressPrinter) {
            return ArchiveProgressPrinter.EMPTY;
        }
        return new LoggingArchiveProgressPrinter(progressPrinter, Clocks.nanoClock());
    }

    LoggingArchiveProgressPrinter(OutputProgressPrinter progressPrinter, SystemNanoClock clock) {
        this.progressPrinter = Objects.requireNonNull(progressPrinter);
        this.clock = clock;
    }

    @Override
    public Resource startPrinting() {
        this.startTime = this.clock.millis();
        this.deadline = new Deadline(this.startTime - PRINT_INTERVAL, PRINT_INTERVAL);
        return () -> {
            this.done();
            this.printProgress();
        };
    }

    @Override
    public void reset() {
        this.maxBytes = 0L;
        this.maxFiles = 0L;
        this.currentBytes = 0L;
        this.currentFiles = 0L;
        this.deadline = null;
        this.percentage = null;
    }

    @Override
    public void maxBytes(long value) {
        this.maxBytes = value;
        this.percentage = new PercentageCondition(value);
    }

    @Override
    public long maxBytes() {
        return this.maxBytes;
    }

    @Override
    public void maxFiles(long value) {
        this.maxFiles = value;
    }

    @Override
    public long maxFiles() {
        return this.maxFiles;
    }

    @Override
    public void beginFile() {
        ++this.currentFiles;
    }

    @Override
    public void printOnNextUpdate() {
        this.force = true;
    }

    @Override
    public void addBytes(long n) {
        boolean percentageReached;
        this.currentBytes += n;
        long when = this.clock.millis();
        boolean deadlineReached = this.deadline != null && this.deadline.reached(when);
        boolean bl = percentageReached = this.percentage != null && this.percentage.updateAndCheckIfReached(this.currentBytes);
        if (this.force || deadlineReached || percentageReached) {
            this.printProgress();
            if (this.deadline != null) {
                this.deadline.next(when);
            }
            this.force = false;
        }
    }

    @Override
    public void endFile() {
        this.printProgress();
    }

    @Override
    public void done() {
        long now = this.clock.millis();
        this.printingTime = (double)(now - this.startTime) / 1000.0;
        this.done = true;
    }

    @VisibleForTesting
    double getPrintingTime() {
        return this.printingTime;
    }

    @Override
    public void printProgress() {
        if (this.done) {
            this.progressPrinter.print("Done: " + this.currentFiles + " files, " + ByteUnit.bytesToString((long)this.currentBytes) + " processed in " + String.format("%.3f", this.printingTime) + " seconds.");
            this.progressPrinter.complete();
        } else if (this.maxFiles > 0L && this.maxBytes > 0L) {
            double progress = (double)this.currentBytes / (double)this.maxBytes * 100.0;
            this.progressPrinter.print("Files: " + this.currentFiles + "/" + this.maxFiles + ", data: " + String.format("%4.1f%%", progress));
        } else {
            this.progressPrinter.print("Files: " + this.currentFiles + "/?, data: ??.?%");
        }
    }

    static class Deadline {
        private final long interval;
        private long target;

        Deadline(long now, long interval) {
            this.interval = interval;
            this.target = now + interval;
        }

        boolean reached(long when) {
            return when >= this.target;
        }

        void next(long now) {
            this.target = now + this.interval;
        }
    }

    static class PercentageCondition {
        final long bucket;
        long current;

        PercentageCondition(long maxBytes) {
            this.bucket = maxBytes / 100L;
            this.current = 0L;
        }

        boolean updateAndCheckIfReached(long currentBytes) {
            if (this.bucket == 0L) {
                return false;
            }
            long previous = this.current;
            this.current = currentBytes / this.bucket;
            return this.current > previous;
        }
    }
}

