/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.DatabaseHealth;

@FunctionalInterface
public interface SystemDatabaseProvider {
    default public GraphDatabaseAPI database() throws SystemDatabaseUnavailableException {
        return this.optionalDatabase().orElseThrow(SystemDatabaseUnavailableException::new);
    }

    public Optional<GraphDatabaseAPI> optionalDatabase();

    default public void execute(Consumer<Transaction> consumer) throws SystemDatabaseUnavailableException {
        this.query(tx -> {
            consumer.accept((Transaction)tx);
            return this;
        });
    }

    default public <T> T query(Function<Transaction, T> function) throws SystemDatabaseUnavailableException {
        return SystemDatabaseProvider.query(this.optionalDatabase(), function, true).orElseThrow();
    }

    default public <T> Optional<T> queryIfAvailable(Function<Transaction, T> function) {
        return SystemDatabaseProvider.query(this.optionalDatabase(), function, false);
    }

    default public <T> Optional<T> dependency(Class<T> type) {
        return this.optionalDatabase().flatMap(dep -> SystemDatabaseProvider.dependency(dep.getDependencyResolver(), type));
    }

    public static <T> Optional<T> dependency(DependencyResolver dependencies, Class<T> type) throws SystemDatabaseUnavailableException {
        if (dependencies.containsDependency(type)) {
            return Optional.of(dependencies.resolveDependency(type));
        }
        return Optional.empty();
    }

    private static <T> Optional<T> query(Optional<GraphDatabaseAPI> optionalDatabase, Function<Transaction, T> function, boolean failOnUnavailable) throws SystemDatabaseUnavailableException {
        if (optionalDatabase.isEmpty()) {
            if (failOnUnavailable) {
                throw new SystemDatabaseUnavailableException();
            }
            return Optional.empty();
        }
        GraphDatabaseAPI database = optionalDatabase.get();
        if (failOnUnavailable) {
            if (!database.isAvailable(1000L)) {
                if (!SystemDatabaseProvider.dependency(database.getDependencyResolver(), DatabaseHealth.class).map(DatabaseHealth::hasNoPanic).orElse(true).booleanValue()) {
                    throw new SystemDatabasePanickedException();
                }
                throw new SystemDatabaseUnavailableException();
            }
        } else if (!database.isAvailable(0L)) {
            return Optional.empty();
        }
        try (Transaction tx = database.beginTx();){
            T result = function.apply(tx);
            tx.commit();
            Optional<T> optional = Optional.of(result);
            return optional;
        }
    }

    public static class SystemDatabaseUnavailableException
    extends RuntimeException {
    }

    public static class SystemDatabasePanickedException
    extends SystemDatabaseUnavailableException {
    }
}

