/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import java.time.Duration;
import java.util.function.BooleanSupplier;
import org.neo4j.dbms.diagnostics.profile.ContinuousProfiler;
import org.neo4j.time.Stopwatch;
import org.neo4j.time.SystemNanoClock;

abstract class PeriodicProfiler
extends ContinuousProfiler {
    private final Duration interval;
    protected final SystemNanoClock clock;
    private Stopwatch stopwatch;

    PeriodicProfiler(Duration interval, SystemNanoClock clock) {
        this.interval = interval;
        this.clock = clock;
    }

    @Override
    protected void run(BooleanSupplier stopCondition) {
        while (!stopCondition.getAsBoolean()) {
            if (this.stopwatch == null || this.stopwatch.hasTimedOut(this.interval)) {
                this.stopwatch = this.clock.startStopWatch();
                this.tick();
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    protected abstract void tick();
}

