/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.diagnostics.profile;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.profile.PeriodicProfiler;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.time.SystemNanoClock;

class JstackProfiler
extends PeriodicProfiler {
    private final JmxDump dump;
    private final FileSystemAbstraction fs;
    private final Path dir;

    JstackProfiler(JmxDump dump, FileSystemAbstraction fs, Path dir, Duration interval, SystemNanoClock clock) {
        super(interval, clock);
        this.dump = dump;
        this.fs = fs;
        this.dir = dir;
        try {
            fs.mkdirs(dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void tick() {
        String threadDump = this.dump.threadDump();
        if (threadDump.equals("ERROR: Unable to produce any thread dump")) {
            throw new IllegalStateException("Failed to retrieve thread dump");
        }
        String name = String.format("threads-%s.txt", this.clock.instant().toString());
        try (OutputStream os = this.fs.openAsOutputStream(this.dir.resolve(name), false);){
            os.write(threadDump.getBytes());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected boolean available() {
        try {
            this.dump.threadDump();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

