/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupCompressionFormat;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV1;

public class BackupZstdFormatV1
implements BackupCompressionFormat {
    static final String MAGIC_HEADER = "BZV1";
    private BackupMetadataV1 metadata;

    @Override
    public void setMetadata(BackupDescription description) {
        this.metadata = new BackupMetadataV1(description);
    }

    @Override
    public OutputStream compress(OutputStream stream) throws IOException {
        stream.write(MAGIC_HEADER.getBytes());
        OutputStream compressionStream = StandardCompressionFormat.ZSTD.compress(stream);
        this.metadata.writeToStream(compressionStream);
        return compressionStream;
    }

    @Override
    public InputStream decompress(InputStream stream) throws IOException {
        InputStream decompress = StandardCompressionFormat.ZSTD.decompress(stream);
        BackupZstdFormatV1.readMetadataFromZstdStream(decompress);
        return decompress;
    }

    @Override
    public BackupCompressionFormat.StreamWithDescription decompressAndDescribe(InputStream stream) throws IOException {
        InputStream decompress = StandardCompressionFormat.ZSTD.decompress(stream);
        BackupDescription description = BackupZstdFormatV1.readMetadataFromZstdStream(decompress).toBackupDescription();
        return new BackupCompressionFormat.StreamWithDescription(decompress, description);
    }

    @Override
    public BackupDescription readMetadata(InputStream inputStream) throws IOException {
        return BackupZstdFormatV1.readMetadataFromZstdStream(StandardCompressionFormat.ZSTD.decompress(inputStream)).toBackupDescription();
    }

    private static BackupMetadataV1 readMetadataFromZstdStream(InputStream inputStream) throws IOException {
        return BackupMetadataV1.readFromStream(inputStream);
    }

    public String toString() {
        return "BackupZstdFormatV1{metadata=" + this.metadata + "}";
    }
}

