/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.BitSet;
import java.util.UUID;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadata;
import org.neo4j.io.fs.InputStreamReadableChannel;
import org.neo4j.io.fs.OutputStreamWritableChannel;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.storageengine.api.StoreId;

public class BackupMetadataV1
implements BackupMetadata {
    private final String databaseName;
    private final StoreId storeId;
    private final DatabaseId databaseId;
    private final LocalDateTime backupTime;
    private final boolean recovered;
    private final boolean compressed;
    private final boolean full;
    private final long lowestTransactionId;
    private final long highestTransactionId;

    public static BackupMetadataV1 readFromStream(InputStream inputStream) throws IOException {
        return BackupMetadataV1.readMetadata(inputStream);
    }

    public BackupMetadataV1(BackupDescription description) {
        this(description.getDatabaseName(), description.getStoreId(), description.getDatabaseId(), description.getBackupTime(), description.getLowestTransactionId(), description.getHighestTransactionId(), description.isRecovered(), description.isCompressed(), description.isFull());
    }

    public BackupMetadataV1(String databaseName, StoreId storeId, DatabaseId databaseId, LocalDateTime backupTime, long lowestTransactionId, long highestTransactionId, boolean recovered, boolean compressed, boolean full) {
        this.databaseName = databaseName;
        this.storeId = storeId;
        this.databaseId = databaseId;
        this.backupTime = backupTime;
        this.recovered = recovered;
        this.compressed = compressed;
        this.full = full;
        this.lowestTransactionId = lowestTransactionId;
        this.highestTransactionId = highestTransactionId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public LocalDateTime getBackupTime() {
        return this.backupTime;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public boolean isFull() {
        return this.full;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void writeToStream(OutputStream compressionStream) throws IOException {
        this.writeStoreId(compressionStream, this.getStoreId());
        BackupMetadataV1.writeDatabaseId(compressionStream, this.getDatabaseId());
        BackupMetadataV1.writeString(compressionStream, this.getDatabaseName());
        BackupMetadataV1.writeLong(compressionStream, this.getBackupTime().toEpochSecond(ZoneOffset.UTC));
        BackupMetadataV1.writeLong(compressionStream, this.lowestTransactionId);
        BackupMetadataV1.writeLong(compressionStream, this.highestTransactionId);
        BitSet flags = new BitSet(3);
        flags.set(0, this.isRecovered());
        flags.set(1, this.isCompressed());
        flags.set(2, this.isFull());
        BackupMetadataV1.writeBitSet(compressionStream, flags);
    }

    private static BackupMetadataV1 readMetadata(InputStream inputStream) throws IOException {
        StoreId storeId = BackupMetadataV1.readStoreId(inputStream);
        DatabaseId databaseId = BackupMetadataV1.readDatabaseId(inputStream);
        String databaseName = BackupMetadataV1.readString(inputStream);
        LocalDateTime backupTime = LocalDateTime.ofEpochSecond(BackupMetadataV1.readLong(inputStream), 0, ZoneOffset.UTC);
        long lowestTransactionId = BackupMetadataV1.readLong(inputStream);
        long highestTransactionId = BackupMetadataV1.readLong(inputStream);
        BitSet flags = BackupMetadataV1.readBitSet(inputStream);
        return new BackupMetadataV1(databaseName, storeId, databaseId, backupTime, lowestTransactionId, highestTransactionId, flags.get(0), flags.get(1), flags.get(2));
    }

    private static void writeLong(OutputStream compressionStream, long value) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(value);
        compressionStream.write(byteBuffer.array());
    }

    private static long readLong(InputStream inputStream) throws IOException {
        return ByteBuffer.wrap(inputStream.readNBytes(8)).getLong();
    }

    private static void writeBitSet(OutputStream outputStream, BitSet bitSet) throws IOException {
        byte[] bitSetBytes = bitSet.toByteArray();
        outputStream.write(bitSetBytes.length);
        outputStream.write(bitSetBytes);
    }

    private static BitSet readBitSet(InputStream inputStream) throws IOException {
        int length = inputStream.read();
        byte[] data = inputStream.readNBytes(length);
        return BitSet.valueOf(data);
    }

    private static void writeString(OutputStream outputStream, String value) throws IOException {
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        outputStream.write(data.length);
        outputStream.write(data);
    }

    private static String readString(InputStream inputStream) throws IOException {
        return new String(inputStream.readNBytes(inputStream.read()), StandardCharsets.UTF_8);
    }

    private void writeStoreId(OutputStream compressionStream, StoreId storeId) throws IOException {
        storeId.serialize((WritableChannel)new OutputStreamWritableChannel(compressionStream));
    }

    private static void writeDatabaseId(OutputStream compressionStream, DatabaseId databaseId) throws IOException {
        UUID uuid = databaseId.uuid();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        byte[] array = byteBuffer.array();
        compressionStream.write(array.length);
        compressionStream.write(array);
    }

    private static StoreId readStoreId(InputStream inputStream) throws IOException {
        return StoreId.deserialize((ReadableChannel)new InputStreamReadableChannel(inputStream));
    }

    private static DatabaseId readDatabaseId(InputStream inputStream) throws IOException {
        byte[] data = inputStream.readNBytes(inputStream.read());
        ByteBuffer buffer = ByteBuffer.wrap(data);
        return DatabaseIdFactory.from((UUID)new UUID(buffer.getLong(), buffer.getLong()));
    }

    @Override
    public BackupDescription toBackupDescription() {
        return new BackupDescription(this.databaseName, this.storeId, this.databaseId, this.backupTime, this.recovered, this.compressed, this.full, this.lowestTransactionId, this.highestTransactionId);
    }
}

