/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.storageengine.api.StoreId;

public class BackupDescription {
    private final String databaseName;
    private final StoreId storeId;
    private final DatabaseId databaseId;
    private final LocalDateTime backupTime;
    private final boolean recovered;
    private final boolean compressed;
    private final boolean full;
    private final long lowestTransactionId;
    private final long highestTransactionId;

    public BackupDescription(String databaseName, StoreId storeId, DatabaseId databaseId, LocalDateTime backupTime, boolean recovered, boolean compressed, boolean full, long lowestTransactionId, long highestTransactionId) {
        this.databaseName = new NormalizedDatabaseName(databaseName).name();
        this.storeId = storeId;
        this.databaseId = databaseId;
        this.backupTime = backupTime.truncatedTo(ChronoUnit.SECONDS);
        this.recovered = recovered;
        this.compressed = compressed;
        this.full = full;
        this.lowestTransactionId = lowestTransactionId;
        this.highestTransactionId = highestTransactionId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        return this.databaseId;
    }

    public LocalDateTime getBackupTime() {
        return this.backupTime;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public boolean isFull() {
        return this.full;
    }

    public long getLowestTransactionId() {
        return this.lowestTransactionId;
    }

    public long getHighestTransactionId() {
        return this.highestTransactionId;
    }

    public boolean isEmpty() {
        return this.lowestTransactionId == 0L && this.highestTransactionId == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupDescription that = (BackupDescription)o;
        return this.recovered == that.recovered && this.compressed == that.compressed && this.full == that.full && this.lowestTransactionId == that.lowestTransactionId && this.highestTransactionId == that.highestTransactionId && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.storeId, that.storeId) && Objects.equals(this.databaseId, that.databaseId) && Objects.equals(this.backupTime, that.backupTime);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.storeId, this.databaseId, this.backupTime, this.recovered, this.compressed, this.full, this.lowestTransactionId, this.highestTransactionId);
    }

    public String toString() {
        return "BackupDescription{databaseName='" + this.databaseName + "', storeId=" + this.storeId + ", databaseId=" + this.databaseId + ", backupTime=" + this.backupTime + ", recovered=" + this.recovered + ", compressed=" + this.compressed + ", full=" + this.full + ", lowestTransactionId=" + this.lowestTransactionId + ", highestTransactionId=" + this.highestTransactionId + "}";
    }
}

