/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.dbms.archive.DumpGzipFormatV1;
import org.neo4j.dbms.archive.DumpZstdFormatV1;
import org.neo4j.dbms.archive.StandardCompressionFormat;
import org.neo4j.function.ThrowingSupplier;

public class DumpFormatSelector {
    private static final int MAGIC_PREFIX_LENGTH = 4;
    public static final char DUMP_PREFIX = 'D';

    public static InputStream decompress(ThrowingSupplier<InputStream, IOException> streamSupplier) throws IOException {
        PushbackInputStream input = new PushbackInputStream((InputStream)streamSupplier.get(), 4);
        CompressionFormat format = DumpFormatSelector.selectInputFormat(input);
        if (format != null) {
            return format.decompress(input);
        }
        return StandardCompressionFormat.decompress((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> {
            try {
                if (input.available() > 0) {
                    return input;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return (InputStream)streamSupplier.get();
        }));
    }

    private static CompressionFormat selectInputFormat(PushbackInputStream stream) throws IOException {
        String magic;
        byte[] bytes = stream.readNBytes(4);
        return switch (magic = new String(bytes)) {
            case "DZV1" -> new DumpZstdFormatV1();
            case "DGV1" -> new DumpGzipFormatV1();
            default -> {
                stream.unread(bytes);
                yield null;
            }
        };
    }

    public static CompressionFormat selectFormat() {
        return DumpFormatSelector.selectFormat(null);
    }

    public static CompressionFormat selectFormat(PrintStream err) {
        if (StandardCompressionFormat.selectCompressionFormat(err) == StandardCompressionFormat.ZSTD) {
            return new DumpZstdFormatV1();
        }
        return new DumpGzipFormatV1();
    }
}

