/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.dbms.archive.CheckDatabase;
import org.neo4j.dbms.archive.DumpFormatSelector;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class CheckDump
implements CheckDatabase {
    private static final float CONSERVATIVE_DISK_SPACE_SCALAR = 1.2f;

    @Override
    public String name() {
        return "dump";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsPotentiallyCheckableDatabase(FileSystemAbstraction fs, CheckDatabase.Source source, NormalizedDatabaseName database) {
        if (!(source instanceof CheckDatabase.Source.PathSource)) return false;
        CheckDatabase.Source.PathSource pathSource = (CheckDatabase.Source.PathSource)source;
        if (!fs.fileExists(CheckDump.dumpFile(pathSource.path, database))) return false;
        return true;
    }

    @Override
    public DatabaseLayout targetLayoutFrom(FileSystemAbstraction fs, CheckDatabase.Source source, NormalizedDatabaseName database, IOUtils.AutoCloseables autoCloseables) throws IOException, CannotWriteException {
        CheckDatabase.Source.PathSource pathSource = CheckDatabase.Source.expected(CheckDatabase.Source.PathSource.class, source);
        CheckDatabase.TempDir temporaryHome = (CheckDatabase.TempDir)autoCloseables.add((AutoCloseable)pathSource.createTemporaryDirectory(fs));
        return Neo4jLayout.ofFlat((Path)temporaryHome.path).databaseLayout(database.name());
    }

    @Override
    public void tryExtract(FileSystemAbstraction fs, DatabaseLayout targetLayout, CheckDatabase.Source source, NormalizedDatabaseName database, PrintStream out, boolean force) throws IOException, IncorrectFormat {
        CheckDatabase.Source.PathSource pathSource = CheckDatabase.Source.expected(CheckDatabase.Source.PathSource.class, source);
        Path dump = CheckDump.dumpFile(pathSource.path, database);
        Loader loader = new Loader(fs, out);
        this.checkDiskSpace(fs, dump, loader, force);
        out.printf("Loading dump from: %s%ninto: %s%n", dump, targetLayout.getNeo4jLayout().dataDirectory());
        loader.load(dump, targetLayout, false, false, DumpFormatSelector::decompress);
    }

    private static Path dumpFile(Path directory, NormalizedDatabaseName database) {
        return directory.resolve(database.name() + ".dump");
    }

    private void checkDiskSpace(FileSystemAbstraction fs, Path dump, Loader loader, boolean force) throws IOException {
        if (force) {
            return;
        }
        long usableSpaceHint = ByteUnit.bytes((long)dump.toFile().getUsableSpace());
        if (usableSpaceHint == ByteUnit.bytes((long)0L)) {
            return;
        }
        Loader.DumpMetaData dumpMeta = loader.getMetaData((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> fs.openAsInputStream(dump)));
        long dumpSize = ByteUnit.bytes((long)Long.parseLong(dumpMeta.byteCount()));
        long conservativeSize = ByteUnit.bytes((long)((long)((float)dumpSize * 1.2f)));
        if (conservativeSize >= usableSpaceHint) {
            throw new FileSystemException("Cannot extract the %s {size: %s} unless there is at least %s of disk space available; this can be overridden by enabling <force>.".formatted(this.name(), ByteUnit.bytesToString((long)dumpSize), ByteUnit.bytesToString((long)conservativeSize)));
        }
    }
}

