/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.database.ExtendedDatabaseInfo;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.database.NamedDatabaseId;

public class DatabaseInfo {
    final NamedDatabaseId namedDatabaseId;
    final ServerId serverId;
    final TopologyGraphDbmsModel.DatabaseAccess access;
    final SocketAddress boltAddress;
    final SocketAddress catchupAddress;
    final String role;
    final String status;
    final String error;

    public DatabaseInfo(NamedDatabaseId namedDatabaseId, ServerId serverId, TopologyGraphDbmsModel.DatabaseAccess access, SocketAddress boltAddress, SocketAddress catchupAddress, String role, String status, String error) {
        this.namedDatabaseId = namedDatabaseId;
        this.serverId = serverId;
        this.access = access;
        this.boltAddress = boltAddress;
        this.catchupAddress = catchupAddress;
        this.role = role;
        this.status = status;
        this.error = error;
    }

    public ExtendedDatabaseInfo extendWith(long lastCommittedTxId) {
        return this.extendWith(lastCommittedTxId, lastCommittedTxId);
    }

    public ExtendedDatabaseInfo extendWith(long lastCommittedTxId, long maxCommittedTxId) {
        return new ExtendedDatabaseInfo(this.namedDatabaseId, this.serverId, this.access, this.boltAddress, this.catchupAddress, this.role, this.status, this.error, lastCommittedTxId, lastCommittedTxId - maxCommittedTxId);
    }

    public NamedDatabaseId namedDatabaseId() {
        return this.namedDatabaseId;
    }

    public Optional<ServerId> serverId() {
        return Optional.ofNullable(this.serverId);
    }

    public ServerId rawServerId() {
        return this.serverId;
    }

    public TopologyGraphDbmsModel.DatabaseAccess access() {
        return this.access;
    }

    public Optional<SocketAddress> boltAddress() {
        return Optional.ofNullable(this.boltAddress);
    }

    public Optional<SocketAddress> catchupAddress() {
        return Optional.ofNullable(this.catchupAddress);
    }

    public String role() {
        return this.role;
    }

    public String status() {
        return this.status;
    }

    public String error() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseInfo that = (DatabaseInfo)o;
        return Objects.equals(this.namedDatabaseId, that.namedDatabaseId) && Objects.equals(this.serverId, that.serverId) && Objects.equals(this.access, that.access) && Objects.equals(this.boltAddress, that.boltAddress) && Objects.equals(this.catchupAddress, that.catchupAddress) && Objects.equals(this.role, that.role) && Objects.equals(this.status, that.status) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.namedDatabaseId, this.serverId, this.access, this.boltAddress, this.catchupAddress, this.role, this.status, this.error);
    }

    public String toString() {
        return "DatabaseInfoImpl{namedDatabaseId=" + this.namedDatabaseId + ", serverId=" + this.serverId + ", accessFromConfig=" + this.access + ", boltAddress=" + this.boltAddress + ", catchupAddress=" + this.catchupAddress + ", role='" + this.role + "', status='" + this.status + "', error='" + this.error + "'}";
    }
}

