/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.File;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.kernel.internal.locker.FileLockException;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import picocli.CommandLine;

@CommandLine.Command(name="store-info", header={"Print information about a Neo4j database store."}, description={"Print information about a Neo4j database store, such as what version of Neo4j created it."})
public class StoreInfoCommand
extends AbstractCommand {
    @CommandLine.Parameters(description={"Path to database store."})
    private File storePath;

    public StoreInfoCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        Validators.CONTAINS_EXISTING_DATABASE.validate((Object)this.storePath);
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((File)this.storePath);
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        try (Closeable ignored = LockChecker.checkDatabaseLock(databaseLayout);
             JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.ctx.fs(), (JobScheduler)jobScheduler, (PageCacheTracer)cacheTracer);){
            StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine();
            StoreVersionCheck storeVersionCheck = storageEngineFactory.versionCheck(this.ctx.fs(), databaseLayout, Config.defaults(), pageCache, (LogService)NullLogService.getInstance(), cacheTracer);
            String storeVersion = (String)storeVersionCheck.storeVersion(PageCursorTracer.NULL).orElseThrow(() -> new CommandFailedException(String.format("Could not find version metadata in store '%s'", this.storePath)));
            String fmt = "%-30s%s";
            this.ctx.out().println(String.format("%-30s%s", "Store format version:", storeVersion));
            StoreVersion versionInformation = storageEngineFactory.versionInformation(storeVersion);
            this.ctx.out().println(String.format("%-30s%s", "Store format introduced in:", versionInformation.introductionNeo4jVersion()));
            versionInformation.successor().map(next -> String.format("%-30s%s", "Store format superseded in:", next.introductionNeo4jVersion())).ifPresent(this.ctx.out()::println);
        }
        catch (FileLockException e) {
            throw new CommandFailedException("The database is in use. Stop database '" + databaseLayout.getDatabaseName() + "' and try again.", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

