/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.neo4j.dbms.archive.ArchiveProgressPrinter;
import org.neo4j.dbms.archive.CompressionFormat;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.InvalidDumpEntryException;
import org.neo4j.dbms.archive.Utils;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Resource;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.util.VisibleForTesting;

public class Loader {
    private final ArchiveProgressPrinter progressPrinter;

    @VisibleForTesting
    Loader() {
        this.progressPrinter = new ArchiveProgressPrinter(null);
    }

    public Loader(PrintStream output) {
        this.progressPrinter = new ArchiveProgressPrinter(output);
    }

    public void load(Path archive, DatabaseLayout databaseLayout) throws IOException, IncorrectFormat {
        Path databaseDestination = databaseLayout.databaseDirectory().toPath();
        Path transactionLogsDirectory = databaseLayout.getTransactionLogsDirectory().toPath();
        this.validatePath(databaseDestination, false);
        this.validatePath(transactionLogsDirectory, true);
        this.createDestination(databaseDestination);
        this.createDestination(transactionLogsDirectory);
        this.checkDatabasePresence(databaseLayout);
        try (ArchiveInputStream stream = this.openArchiveIn(archive);
             Resource ignore = this.progressPrinter.startPrinting();){
            ArchiveEntry entry;
            while ((entry = this.nextEntry(stream, archive)) != null) {
                Path destination = Loader.determineEntryDestination(entry, databaseDestination, transactionLogsDirectory);
                this.loadEntry(destination, stream, entry);
            }
        }
    }

    public DumpMetaData getMetaData(Path archive) throws IOException {
        try (InputStream decompressor = CompressionFormat.decompress((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> Files.newInputStream(archive, new OpenOption[0])));){
            String format = "TAR+GZIP.";
            String files = "?";
            String bytes = "?";
            if (CompressionFormat.ZSTD.isFormat(decompressor)) {
                format = "Neo4j ZSTD Dump.";
                this.readArchiveMetadata(decompressor);
                files = String.valueOf(this.progressPrinter.maxFiles);
                bytes = String.valueOf(this.progressPrinter.maxBytes);
            }
            DumpMetaData dumpMetaData = new DumpMetaData(format, files, bytes);
            return dumpMetaData;
        }
    }

    private void checkDatabasePresence(DatabaseLayout databaseLayout) throws FileAlreadyExistsException {
        if (databaseLayout.metadataStore().exists()) {
            throw new FileAlreadyExistsException(databaseLayout.metadataStore().getAbsolutePath());
        }
    }

    private void createDestination(Path destination) throws IOException {
        if (!destination.toFile().exists()) {
            Files.createDirectories(destination, new FileAttribute[0]);
        }
    }

    private void validatePath(Path path, boolean validateExistence) throws FileSystemException {
        if (validateExistence && Files.exists(path, new LinkOption[0])) {
            throw new FileAlreadyExistsException(path.toString());
        }
        Utils.checkWritableDirectory(path.getParent());
    }

    private static Path determineEntryDestination(ArchiveEntry entry, Path databaseDestination, Path transactionLogsDirectory) {
        String entryName = Paths.get(entry.getName(), new String[0]).getFileName().toString();
        return TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(null, entryName) ? transactionLogsDirectory : databaseDestination;
    }

    private ArchiveEntry nextEntry(ArchiveInputStream stream, Path archive) throws IncorrectFormat {
        try {
            return stream.getNextEntry();
        }
        catch (IOException e) {
            throw new IncorrectFormat(archive, e);
        }
    }

    private void loadEntry(Path destination, ArchiveInputStream stream, ArchiveEntry entry) throws IOException {
        Path file = destination.resolve(entry.getName());
        if (!file.normalize().startsWith(destination)) {
            throw new InvalidDumpEntryException(entry.getName());
        }
        if (entry.isDirectory()) {
            Files.createDirectories(file, new FileAttribute[0]);
        } else {
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                Utils.copy((InputStream)stream, output, this.progressPrinter);
            }
        }
    }

    private ArchiveInputStream openArchiveIn(Path archive) throws IOException, IncorrectFormat {
        try {
            InputStream decompressor = CompressionFormat.decompress((ThrowingSupplier<InputStream, IOException>)((ThrowingSupplier)() -> Files.newInputStream(archive, new OpenOption[0])));
            if (CompressionFormat.ZSTD.isFormat(decompressor)) {
                this.readArchiveMetadata(decompressor);
            }
            return new TarArchiveInputStream(decompressor);
        }
        catch (NoSuchFileException ioe) {
            throw ioe;
        }
        catch (IOException e) {
            throw new IncorrectFormat(archive, e);
        }
    }

    void readArchiveMetadata(InputStream stream) throws IOException {
        DataInputStream metadata = new DataInputStream(stream);
        int version = metadata.readInt();
        if (version != 1) {
            throw new IOException("Cannot read archive meta-data. I don't recognise this archive version: " + version + ".");
        }
        this.progressPrinter.maxFiles = metadata.readLong();
        this.progressPrinter.maxBytes = metadata.readLong();
    }

    public static class DumpMetaData {
        public final String format;
        public final String fileCount;
        public final String byteCount;

        public DumpMetaData(String format, String fileCount, String byteCount) {
            this.format = format;
            this.fileCount = fileCount;
            this.byteCount = byteCount;
        }
    }
}

