/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.commandline.dbms.storeutil.StoreCopyStats;
import org.neo4j.token.api.TokenNotFoundException;

class StoreCopyFilter {
    private final StoreCopyStats stats;
    private final ImmutableIntSet deleteNodesWithLabelsIds;
    private final Set<Integer> skipLabelsIds;
    private final Set<Integer> skipPropertyIds;
    private final Set<Integer> skipRelationshipIds;

    StoreCopyFilter(StoreCopyStats stats, int[] deleteNodesWithLabelsIds, int[] skipLabelsIds, int[] skipPropertyIds, int[] skipRelationshipIds) {
        this.stats = stats;
        this.deleteNodesWithLabelsIds = IntSets.immutable.of(deleteNodesWithLabelsIds);
        this.skipLabelsIds = ConcurrentHashMap.newKeySet();
        this.skipPropertyIds = ConcurrentHashMap.newKeySet();
        this.skipRelationshipIds = ConcurrentHashMap.newKeySet();
        Arrays.stream(skipLabelsIds).forEach(this.skipLabelsIds::add);
        Arrays.stream(skipPropertyIds).forEach(this.skipPropertyIds::add);
        Arrays.stream(skipRelationshipIds).forEach(this.skipRelationshipIds::add);
    }

    boolean shouldDeleteNode(long[] labelIds) {
        for (long labelId : labelIds) {
            if (!this.deleteNodesWithLabelsIds.contains(Math.toIntExact(labelId))) continue;
            return true;
        }
        return false;
    }

    String[] filterLabels(long[] labelIds, TokenLookup tokenLookup) {
        ArrayList<String> labels = new ArrayList<String>(labelIds.length);
        for (long longLabelId : labelIds) {
            int labelId = Math.toIntExact(longLabelId);
            if (this.skipLabelsIds.contains(labelId)) continue;
            try {
                labels.add(tokenLookup.lookup(labelId));
            }
            catch (TokenNotFoundException e) {
                this.skipLabelsIds.add(labelId);
                this.stats.addCorruptToken("Label", labelId);
            }
        }
        return labels.toArray(new String[0]);
    }

    boolean shouldKeepProperty(int keyIndexId) {
        return !this.skipPropertyIds.contains(keyIndexId);
    }

    String filterRelationship(int relTypeId, TokenLookup tokenLookup) {
        if (!this.skipRelationshipIds.contains(relTypeId)) {
            try {
                return tokenLookup.lookup(relTypeId);
            }
            catch (TokenNotFoundException e) {
                this.skipRelationshipIds.add(relTypeId);
                this.stats.addCorruptToken("Relationship", relTypeId);
            }
        }
        return null;
    }

    @FunctionalInterface
    static interface TokenLookup {
        public String lookup(int var1) throws TokenNotFoundException;
    }
}

