/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.storeutil;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.logging.Log;
import org.neo4j.values.storable.Value;

class StoreCopyStats {
    private static final int MAX_LOG_LENGTH = 120;
    private final long startTime;
    private final Log log;
    final LongAdder count = new LongAdder();
    final LongAdder unused = new LongAdder();
    final LongAdder removed = new LongAdder();

    StoreCopyStats(Log log) {
        this.log = log;
        this.startTime = System.nanoTime();
    }

    void addCorruptToken(String type, int id) {
        this.log.error("%s(%d): Missing token name", new Object[]{type, id});
    }

    void brokenPropertyToken(String type, PrimitiveRecord record, Value newPropertyValue, int keyIndexId) {
        String value = newPropertyValue.toString();
        this.log.error("%s(%d): Ignoring property with missing token(%d). Value of the property is %s.", new Object[]{type, record.getId(), keyIndexId, StoreCopyStats.trimToMaxLength(value)});
    }

    void brokenPropertyChain(String type, PrimitiveRecord record, Exception e) {
        this.log.error(String.format("%s(%d): Ignoring broken property chain.", type, record.getId()), (Throwable)e);
    }

    void brokenRecord(String type, long id, Exception e) {
        this.log.error(String.format("%s(%d): Ignoring broken record.", type, id), (Throwable)e);
    }

    void printSummary() {
        long seconds = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.startTime);
        long count = this.count.sum();
        long unused = this.unused.sum();
        long removed = this.removed.sum();
        this.log.info("Import summary: Copying of %d records took %d seconds (%d rec/s). Unused Records %d (%d%%) Removed Records %d (%d%%)", new Object[]{count, seconds, count / Math.max(1L, seconds), unused, StoreCopyStats.percent(unused, count), removed, StoreCopyStats.percent(removed, count)});
    }

    void invalidIndex(IndexDescriptor indexDescriptor, Exception e) {
        this.log.error(String.format("Unable to format statement for index '%s'%n", indexDescriptor.getName()), (Throwable)e);
    }

    void invalidConstraint(ConstraintDescriptor constraintDescriptor, Exception e) {
        this.log.error(String.format("Unable to format statement for constraint '%s'%n", constraintDescriptor.getName()), (Throwable)e);
    }

    private static int percent(long part, long total) {
        if (total == 0L) {
            return 0;
        }
        return (int)(100.0 * (double)part / (double)total);
    }

    private static String trimToMaxLength(String value) {
        return value.length() <= 120 ? value : value.substring(0, 120) + "..";
    }
}

